/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.metadata;

import com.datastax.oss.driver.api.core.metadata.EndPoint;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.internal.core.context.InternalDriverContext;
import com.datastax.oss.driver.internal.core.metadata.DefaultMetadata;
import com.datastax.oss.driver.internal.core.metadata.DefaultNode;
import com.datastax.oss.driver.internal.core.metadata.MetadataRefresh;
import com.datastax.oss.driver.internal.core.metadata.NodeInfo;
import com.datastax.oss.driver.internal.core.metadata.NodeStateEvent;
import com.datastax.oss.driver.internal.core.metadata.NodesRefresh;
import com.datastax.oss.driver.internal.core.metadata.token.TokenFactory;
import com.datastax.oss.driver.internal.core.metadata.token.TokenFactoryRegistry;
import com.datastax.oss.driver.shaded.guava.common.annotations.VisibleForTesting;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableList;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
class InitialNodeListRefresh
extends NodesRefresh {
    private static final Logger LOG = LoggerFactory.getLogger(InitialNodeListRefresh.class);
    @VisibleForTesting
    final Iterable<NodeInfo> nodeInfos;
    @VisibleForTesting
    final Set<DefaultNode> contactPoints;

    InitialNodeListRefresh(Iterable<NodeInfo> nodeInfos, Set<DefaultNode> contactPoints) {
        this.nodeInfos = nodeInfos;
        this.contactPoints = contactPoints;
    }

    @Override
    public MetadataRefresh.Result compute(DefaultMetadata oldMetadata, boolean tokenMapEnabled, InternalDriverContext context) {
        String logPrefix = context.getSessionName();
        TokenFactoryRegistry tokenFactoryRegistry = context.getTokenFactoryRegistry();
        assert (oldMetadata == DefaultMetadata.EMPTY);
        TokenFactory tokenFactory = null;
        HashMap<UUID, DefaultNode> newNodes = new HashMap<UUID, DefaultNode>();
        for (NodeInfo nodeInfo : this.nodeInfos) {
            UUID hostId = nodeInfo.getHostId();
            if (newNodes.containsKey(hostId)) {
                LOG.warn("[{}] Found duplicate entries with host_id {} in system.peers, keeping only the first one", (Object)logPrefix, (Object)hostId);
                continue;
            }
            EndPoint endPoint = nodeInfo.getEndPoint();
            DefaultNode node = this.findIn(this.contactPoints, endPoint);
            if (node == null) {
                node = new DefaultNode(endPoint, context);
                LOG.debug("[{}] Adding new node {}", (Object)logPrefix, (Object)node);
            } else {
                LOG.debug("[{}] Copying contact point {}", (Object)logPrefix, (Object)node);
            }
            if (tokenMapEnabled && tokenFactory == null && nodeInfo.getPartitioner() != null) {
                tokenFactory = tokenFactoryRegistry.tokenFactoryFor(nodeInfo.getPartitioner());
            }
            InitialNodeListRefresh.copyInfos(nodeInfo, node, context);
            newNodes.put(hostId, node);
        }
        ImmutableList.Builder eventsBuilder = ImmutableList.builder();
        for (DefaultNode newNode : newNodes.values()) {
            if (this.findIn(this.contactPoints, newNode.getEndPoint()) != null) continue;
            eventsBuilder.add((Object)NodeStateEvent.added(newNode));
        }
        for (DefaultNode contactPoint : this.contactPoints) {
            if (this.findIn(newNodes.values(), contactPoint.getEndPoint()) != null) continue;
            eventsBuilder.add((Object)NodeStateEvent.removed(contactPoint));
        }
        return new MetadataRefresh.Result(oldMetadata.withNodes((Map<UUID, Node>)ImmutableMap.copyOf(newNodes), tokenMapEnabled, true, tokenFactory, context), (List<Object>)eventsBuilder.build());
    }

    private DefaultNode findIn(Iterable<? extends Node> nodes, EndPoint endPoint) {
        for (Node node : nodes) {
            if (!node.getEndPoint().equals(endPoint)) continue;
            return (DefaultNode)node;
        }
        return null;
    }
}

