/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.api.core.metadata;

import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.api.core.metadata.NodeStateListener;
import com.datastax.oss.driver.api.core.session.Session;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.BiConsumer;
import net.jcip.annotations.GuardedBy;

public class SafeInitNodeStateListener
implements NodeStateListener {
    private final NodeStateListener delegate;
    private final boolean replayInitEvents;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    @GuardedBy(value="lock")
    private boolean sessionReady;
    @GuardedBy(value="lock")
    private final List<InitEvent> initEvents = new ArrayList<InitEvent>();

    public SafeInitNodeStateListener(@NonNull NodeStateListener delegate, boolean replayInitEvents) {
        this.delegate = Objects.requireNonNull(delegate);
        this.replayInitEvents = replayInitEvents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onSessionReady(@NonNull Session session) {
        this.lock.writeLock().lock();
        try {
            if (!this.sessionReady) {
                this.sessionReady = true;
                this.delegate.onSessionReady(session);
                if (this.replayInitEvents) {
                    for (InitEvent event : this.initEvents) {
                        event.invoke(this.delegate);
                    }
                }
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void onAdd(@NonNull Node node) {
        this.onEvent(node, InitEvent.Type.ADD);
    }

    @Override
    public void onUp(@NonNull Node node) {
        this.onEvent(node, InitEvent.Type.UP);
    }

    @Override
    public void onDown(@NonNull Node node) {
        this.onEvent(node, InitEvent.Type.DOWN);
    }

    @Override
    public void onRemove(@NonNull Node node) {
        this.onEvent(node, InitEvent.Type.REMOVE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onEvent(Node node, InitEvent.Type eventType) {
        this.lock.readLock().lock();
        try {
            if (this.sessionReady) {
                eventType.listenerMethod.accept(this.delegate, node);
                return;
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        if (this.replayInitEvents) {
            this.lock.writeLock().lock();
            try {
                if (this.sessionReady) {
                    eventType.listenerMethod.accept(this.delegate, node);
                } else {
                    this.initEvents.add(new InitEvent(node, eventType));
                }
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
    }

    @Override
    public void close() throws Exception {
        this.delegate.close();
    }

    private static class InitEvent {
        final Node node;
        final Type type;

        InitEvent(@NonNull Node node, @NonNull Type type) {
            this.node = Objects.requireNonNull(node);
            this.type = Objects.requireNonNull(type);
        }

        void invoke(@NonNull NodeStateListener target) {
            this.type.listenerMethod.accept(Objects.requireNonNull(target), this.node);
        }

        static enum Type {
            ADD(NodeStateListener::onAdd),
            UP(NodeStateListener::onUp),
            DOWN(NodeStateListener::onDown),
            REMOVE(NodeStateListener::onRemove);

            final BiConsumer<NodeStateListener, Node> listenerMethod;

            private Type(BiConsumer<NodeStateListener, Node> listenerMethod) {
                this.listenerMethod = listenerMethod;
            }
        }
    }
}

