/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.internal.core.metadata.schema;

import com.datastax.dse.driver.api.core.metadata.schema.DseFunctionMetadata;
import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.metadata.schema.FunctionSignature;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.internal.core.metadata.schema.DefaultFunctionMetadata;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableList;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.jcip.annotations.Immutable;

@Immutable
public class DefaultDseFunctionMetadata
extends DefaultFunctionMetadata
implements DseFunctionMetadata {
    @Nullable
    private final Boolean deterministic;
    @Nullable
    private final DseFunctionMetadata.Monotonicity monotonicity;
    @NonNull
    private final List<CqlIdentifier> monotonicArgumentNames;

    public DefaultDseFunctionMetadata(@NonNull CqlIdentifier keyspace, @NonNull FunctionSignature signature, @NonNull List<CqlIdentifier> parameterNames, @NonNull String body, boolean calledOnNullInput, @NonNull String language, @NonNull DataType returnType, @Nullable Boolean deterministic, @Nullable Boolean monotonic, @NonNull List<CqlIdentifier> monotonicArgumentNames) {
        super(keyspace, signature, parameterNames, body, calledOnNullInput, language, returnType);
        this.deterministic = deterministic;
        this.monotonicity = monotonic == null ? null : (monotonic != false ? DseFunctionMetadata.Monotonicity.FULLY_MONOTONIC : (monotonicArgumentNames.isEmpty() ? DseFunctionMetadata.Monotonicity.NOT_MONOTONIC : DseFunctionMetadata.Monotonicity.PARTIALLY_MONOTONIC));
        this.monotonicArgumentNames = ImmutableList.copyOf(monotonicArgumentNames);
    }

    @Override
    @Deprecated
    public boolean isDeterministic() {
        return this.deterministic != null && this.deterministic != false;
    }

    @Override
    public Optional<Boolean> getDeterministic() {
        return Optional.ofNullable(this.deterministic);
    }

    @Override
    @Deprecated
    public boolean isMonotonic() {
        return this.monotonicity == DseFunctionMetadata.Monotonicity.FULLY_MONOTONIC;
    }

    @Override
    public Optional<DseFunctionMetadata.Monotonicity> getMonotonicity() {
        return Optional.ofNullable(this.monotonicity);
    }

    @Override
    @NonNull
    public List<CqlIdentifier> getMonotonicArgumentNames() {
        return this.monotonicArgumentNames;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof DseFunctionMetadata) {
            DseFunctionMetadata that = (DseFunctionMetadata)other;
            return Objects.equals(this.getKeyspace(), that.getKeyspace()) && Objects.equals(this.getSignature(), that.getSignature()) && Objects.equals(this.getParameterNames(), that.getParameterNames()) && Objects.equals(this.getBody(), that.getBody()) && this.isCalledOnNullInput() == that.isCalledOnNullInput() && Objects.equals(this.getLanguage(), that.getLanguage()) && Objects.equals(this.getReturnType(), that.getReturnType()) && Objects.equals(this.deterministic, that.getDeterministic().orElse(null)) && this.monotonicity == that.getMonotonicity().orElse(null) && Objects.equals(this.monotonicArgumentNames, that.getMonotonicArgumentNames());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.getKeyspace(), this.getSignature(), this.getParameterNames(), this.getBody(), this.isCalledOnNullInput(), this.getLanguage(), this.getReturnType(), this.deterministic, this.monotonicity, this.monotonicArgumentNames});
    }

    @Override
    public String toString() {
        return "Function Name: " + this.getSignature().getName().asCql(false) + ", Keyspace: " + this.getKeyspace().asCql(false) + ", Language: " + this.getLanguage() + ", Return Type: " + this.getReturnType().asCql(false, false) + ", Deterministic: " + this.deterministic + ", Monotonicity: " + (Object)((Object)this.monotonicity) + ", Monotonic On: " + (this.monotonicArgumentNames.isEmpty() ? "" : (Serializable)this.monotonicArgumentNames.get(0));
    }
}

