/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.internal.core.graph;

import com.datastax.dse.driver.internal.core.graph.BytecodeGraphStatement;
import com.datastax.dse.driver.internal.core.graph.DseGraphTraversal;
import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import java.util.concurrent.CompletableFuture;
import net.jcip.annotations.Immutable;
import org.apache.tinkerpop.gremlin.process.remote.RemoteConnection;
import org.apache.tinkerpop.gremlin.process.remote.traversal.RemoteTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.Bytecode;

@Immutable
public class DseGraphRemoteConnection
implements RemoteConnection {
    private final CqlSession session;
    private final DriverExecutionProfile executionProfile;
    private final String executionProfileName;

    public DseGraphRemoteConnection(CqlSession session, DriverExecutionProfile executionProfile, String executionProfileName) {
        this.session = session;
        this.executionProfile = executionProfile;
        this.executionProfileName = executionProfileName;
    }

    public <E> CompletableFuture<RemoteTraversal<?, E>> submitAsync(Bytecode bytecode) {
        return this.session.executeAsync(new BytecodeGraphStatement(bytecode, this.executionProfile, this.executionProfileName)).toCompletableFuture().thenApply(DseGraphTraversal::new);
    }

    public void close() throws Exception {
    }
}

