/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.api.core.graph.predicates;

import com.datastax.dse.driver.api.core.data.geometry.LineString;
import com.datastax.dse.driver.api.core.data.geometry.Point;
import com.datastax.dse.driver.api.core.data.geometry.Polygon;
import com.datastax.dse.driver.internal.core.data.geometry.Distance;
import com.datastax.dse.driver.internal.core.graph.GeoPredicate;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.function.BiPredicate;
import org.apache.tinkerpop.gremlin.process.traversal.P;

public interface Geo {
    public static P<Object> inside(Point center, double radius, Unit units) {
        return new P((BiPredicate)GeoPredicate.inside, (Object)new Distance(center, units.toDegrees(radius)));
    }

    public static P<Object> inside(Point center, double radius) {
        return new P((BiPredicate)GeoPredicate.insideCartesian, (Object)new Distance(center, radius));
    }

    public static P<Object> inside(Polygon polygon) {
        return new P((BiPredicate)GeoPredicate.insideCartesian, (Object)polygon);
    }

    @NonNull
    public static Point point(double x, double y) {
        return Point.fromCoordinates(x, y);
    }

    @NonNull
    public static LineString lineString(@NonNull Point point1, @NonNull Point point2, Point ... otherPoints) {
        return LineString.fromPoints(point1, point2, otherPoints);
    }

    @NonNull
    public static LineString lineString(double ... coordinates) {
        if (coordinates.length % 2 != 0) {
            throw new IllegalArgumentException("lineString() must be passed an even number of arguments");
        }
        if (coordinates.length < 4) {
            throw new IllegalArgumentException("lineString() must be passed at least 4 arguments (2 points)");
        }
        Point point1 = Point.fromCoordinates(coordinates[0], coordinates[1]);
        Point point2 = Point.fromCoordinates(coordinates[2], coordinates[3]);
        Point[] otherPoints = new Point[coordinates.length / 2 - 2];
        for (int i = 4; i < coordinates.length; i += 2) {
            otherPoints[i / 2 - 2] = Point.fromCoordinates(coordinates[i], coordinates[i + 1]);
        }
        return LineString.fromPoints(point1, point2, otherPoints);
    }

    @NonNull
    public static Polygon polygon(@NonNull Point p1, @NonNull Point p2, @NonNull Point p3, Point ... otherPoints) {
        return Polygon.fromPoints(p1, p2, p3, otherPoints);
    }

    @NonNull
    public static Polygon polygon(double ... coordinates) {
        if (coordinates.length % 2 != 0) {
            throw new IllegalArgumentException("polygon() must be passed an even number of arguments");
        }
        if (coordinates.length < 6) {
            throw new IllegalArgumentException("polygon() must be passed at least 6 arguments (3 points)");
        }
        Point point1 = Point.fromCoordinates(coordinates[0], coordinates[1]);
        Point point2 = Point.fromCoordinates(coordinates[2], coordinates[3]);
        Point point3 = Point.fromCoordinates(coordinates[4], coordinates[5]);
        Point[] otherPoints = new Point[coordinates.length / 2 - 3];
        for (int i = 6; i < coordinates.length; i += 2) {
            otherPoints[i / 2 - 3] = Point.fromCoordinates(coordinates[i], coordinates[i + 1]);
        }
        return Polygon.fromPoints(point1, point2, point3, otherPoints);
    }

    public static enum Unit {
        MILES(0.014473158384878317),
        KILOMETERS(0.008993203677616635),
        METERS(8.993203677616634E-6),
        DEGREES(1.0);

        private final double multiplier;

        private Unit(double multiplier) {
            this.multiplier = multiplier;
        }

        public double toDegrees(double distance) {
            return distance * this.multiplier;
        }
    }
}

