/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.metrics;

import java.io.IOException;
import org.apache.beam.runners.core.metrics.MetricsContainerStepMap;
import org.apache.beam.runners.spark.SparkPipelineOptions;
import org.apache.beam.runners.spark.metrics.MetricsContainerStepMapAccumulator;
import org.apache.beam.runners.spark.metrics.SparkMetricsContainerStepMap;
import org.apache.beam.runners.spark.translation.streaming.Checkpoint;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Optional;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.streaming.api.java.JavaStreamingListener;
import org.apache.spark.streaming.api.java.JavaStreamingListenerBatchCompleted;
import org.apache.spark.util.AccumulatorV2;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricsAccumulator {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(MetricsAccumulator.class);
    private static final @UnknownKeyFor @NonNull @Initialized String ACCUMULATOR_NAME = "Beam.Metrics";
    private static final @UnknownKeyFor @NonNull @Initialized String ACCUMULATOR_CHECKPOINT_FILENAME = "metrics";
    private static volatile @UnknownKeyFor @NonNull @Initialized MetricsContainerStepMapAccumulator instance = null;
    private static volatile @UnknownKeyFor @NonNull @Initialized FileSystem fileSystem;
    private static volatile @UnknownKeyFor @NonNull @Initialized Path checkpointFilePath;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init(@UnknownKeyFor @NonNull @Initialized SparkPipelineOptions opts, @UnknownKeyFor @NonNull @Initialized JavaSparkContext jsc) {
        if (instance == null) {
            Class<MetricsAccumulator> clazz = MetricsAccumulator.class;
            synchronized (MetricsAccumulator.class) {
                if (instance == null) {
                    Optional<MetricsContainerStepMap> maybeRecoveredValue;
                    Optional maybeCheckpointDir = opts.isStreaming() ? Optional.of((Object)new Checkpoint.CheckpointDir(opts.getCheckpointDir())) : Optional.absent();
                    SparkMetricsContainerStepMap metricsContainerStepMap = new SparkMetricsContainerStepMap();
                    MetricsContainerStepMapAccumulator accumulator = new MetricsContainerStepMapAccumulator(metricsContainerStepMap);
                    if (maybeCheckpointDir.isPresent() && (maybeRecoveredValue = MetricsAccumulator.recoverValueFromCheckpoint(jsc, (Checkpoint.CheckpointDir)maybeCheckpointDir.get())).isPresent()) {
                        accumulator = new MetricsContainerStepMapAccumulator((MetricsContainerStepMap)maybeRecoveredValue.get());
                    }
                    jsc.sc().register((AccumulatorV2)accumulator, ACCUMULATOR_NAME);
                    instance = accumulator;
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                LOG.info("Instantiated metrics accumulator: {}", (Object)instance.value());
            }
        } else {
            instance.reset();
        }
    }

    public static @UnknownKeyFor @NonNull @Initialized MetricsContainerStepMapAccumulator getInstance() {
        if (instance == null) {
            throw new IllegalStateException("Metrics accumulator has not been instantiated");
        }
        return instance;
    }

    private static @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized MetricsContainerStepMap> recoverValueFromCheckpoint(@UnknownKeyFor @NonNull @Initialized JavaSparkContext jsc, @UnknownKeyFor @NonNull @Initialized Checkpoint.CheckpointDir checkpointDir) {
        try {
            Path beamCheckpointPath = checkpointDir.getBeamCheckpointDir();
            checkpointFilePath = new Path(beamCheckpointPath, ACCUMULATOR_CHECKPOINT_FILENAME);
            fileSystem = checkpointFilePath.getFileSystem(jsc.hadoopConfiguration());
            SparkMetricsContainerStepMap recoveredValue = (SparkMetricsContainerStepMap)((Object)Checkpoint.readObject(fileSystem, checkpointFilePath));
            if (recoveredValue != null) {
                LOG.info("Recovered metrics from checkpoint.");
                return Optional.of((Object)((Object)recoveredValue));
            }
            LOG.info("No metrics checkpoint found.");
        }
        catch (Exception e) {
            throw new RuntimeException("Failure while reading metrics checkpoint.", e);
        }
        return Optional.absent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public static void clear() {
        Class<MetricsAccumulator> clazz = MetricsAccumulator.class;
        synchronized (MetricsAccumulator.class) {
            instance = null;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    private static void checkpoint() throws @UnknownKeyFor @NonNull @Initialized IOException {
        if (checkpointFilePath != null) {
            Checkpoint.writeObject(fileSystem, checkpointFilePath, instance.value());
        }
    }

    public static class AccumulatorCheckpointingSparkListener
    extends JavaStreamingListener {
        public void onBatchCompleted(@UnknownKeyFor @NonNull @Initialized JavaStreamingListenerBatchCompleted batchCompleted) {
            try {
                MetricsAccumulator.checkpoint();
            }
            catch (IOException e) {
                LOG.error("Failed to checkpoint metrics singleton.", (Throwable)e);
            }
        }
    }
}

