/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark;

import java.io.OutputStream;
import org.apache.beam.runners.jobsubmission.JobServerDriver;
import org.apache.beam.runners.spark.SparkJobInvoker;
import org.apache.beam.sdk.extensions.gcp.options.GcsOptions;
import org.apache.beam.sdk.fn.server.ServerFactory;
import org.apache.beam.sdk.io.FileSystems;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SparkJobServerDriver
extends JobServerDriver {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(SparkJobServerDriver.class);

    public static void main(@UnknownKeyFor @NonNull @Initialized String @UnknownKeyFor @NonNull @Initialized [] args) {
        PipelineOptions options = PipelineOptionsFactory.create();
        ((GcsOptions)options.as(GcsOptions.class)).setGcsUploadBufferSizeBytes(Integer.valueOf(0x100000));
        FileSystems.setDefaultPipelineOptions((PipelineOptions)options);
        SparkJobServerDriver.fromParams(args).run();
    }

    private static void printUsage(@UnknownKeyFor @NonNull @Initialized CmdLineParser parser) {
        System.err.println(String.format("Usage: java %s arguments...", SparkJobServerDriver.class.getSimpleName()));
        parser.printUsage((OutputStream)System.err);
        System.err.println();
    }

    public static @UnknownKeyFor @NonNull @Initialized SparkJobServerDriver fromParams(@UnknownKeyFor @NonNull @Initialized String @UnknownKeyFor @NonNull @Initialized [] args) {
        SparkServerConfiguration configuration = new SparkServerConfiguration();
        CmdLineParser parser = new CmdLineParser((Object)configuration);
        try {
            parser.parseArgument(args);
        }
        catch (CmdLineException e) {
            LOG.error("Unable to parse command line arguments.", (Throwable)e);
            SparkJobServerDriver.printUsage(parser);
            throw new IllegalArgumentException("Unable to parse command line arguments.", e);
        }
        return SparkJobServerDriver.fromConfig(configuration);
    }

    public static @UnknownKeyFor @NonNull @Initialized SparkJobServerDriver fromConfig(@UnknownKeyFor @NonNull @Initialized SparkServerConfiguration configuration) {
        return SparkJobServerDriver.create(configuration, SparkJobServerDriver.createJobServerFactory((JobServerDriver.ServerConfiguration)configuration), SparkJobServerDriver.createArtifactServerFactory((JobServerDriver.ServerConfiguration)configuration));
    }

    private static @UnknownKeyFor @NonNull @Initialized SparkJobServerDriver create(@UnknownKeyFor @NonNull @Initialized SparkServerConfiguration configuration, @UnknownKeyFor @NonNull @Initialized ServerFactory jobServerFactory, @UnknownKeyFor @NonNull @Initialized ServerFactory artifactServerFactory) {
        return new SparkJobServerDriver(configuration, jobServerFactory, artifactServerFactory);
    }

    private SparkJobServerDriver(@UnknownKeyFor @NonNull @Initialized SparkServerConfiguration configuration, @UnknownKeyFor @NonNull @Initialized ServerFactory jobServerFactory, @UnknownKeyFor @NonNull @Initialized ServerFactory artifactServerFactory) {
        super((JobServerDriver.ServerConfiguration)configuration, jobServerFactory, artifactServerFactory, () -> SparkJobInvoker.create(configuration));
    }

    public static class SparkServerConfiguration
    extends JobServerDriver.ServerConfiguration {
        @Option(name="--spark-master-url", usage="Spark master url to submit job (e.g. spark://host:port, local[4])")
        private @UnknownKeyFor @NonNull @Initialized String sparkMasterUrl = "local[4]";

        @UnknownKeyFor @NonNull @Initialized String getSparkMasterUrl() {
            return this.sparkMasterUrl;
        }
    }
}

