/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.dataflow.util;

import java.io.Serializable;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.beam.runners.dataflow.util.CloudObject;
import org.apache.beam.runners.dataflow.util.CloudObjectTranslator;
import org.apache.beam.runners.dataflow.util.Structs;
import org.apache.beam.sdk.extensions.avro.coders.AvroCoder;
import org.apache.beam.sdk.extensions.avro.io.AvroDatumFactory;
import org.apache.beam.sdk.util.SerializableUtils;
import org.apache.beam.sdk.util.StringUtils;
import org.apache.beam.sdk.util.construction.SdkComponents;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

class AvroCoderCloudObjectTranslator
implements CloudObjectTranslator<AvroCoder> {
    private static final @UnknownKeyFor @NonNull @Initialized String DATUM_FACTORY_FIELD = "datum_factory";
    private static final @UnknownKeyFor @NonNull @Initialized String SCHEMA_FIELD = "schema";
    private static final @UnknownKeyFor @NonNull @Initialized String TYPE_FIELD = "type";
    private static final @UnknownKeyFor @NonNull @Initialized String REFLECT_API_FIELD = "reflect_api";

    AvroCoderCloudObjectTranslator() {
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized CloudObject toCloudObject(@UnknownKeyFor @NonNull @Initialized AvroCoder target, @UnknownKeyFor @NonNull @Initialized SdkComponents sdkComponents) {
        CloudObject base = CloudObject.forClass(AvroCoder.class);
        byte[] serializedDatumFactory = SerializableUtils.serializeToByteArray((Serializable)target.getDatumFactory());
        Structs.addString((Map<String, Object>)((Object)base), DATUM_FACTORY_FIELD, StringUtils.byteArrayToJsonString((byte[])serializedDatumFactory));
        Structs.addString((Map<String, Object>)((Object)base), SCHEMA_FIELD, target.getSchema().toString());
        return base;
    }

    @Override
    public /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized AvroCoder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> fromCloudObject(@UnknownKeyFor @NonNull @Initialized CloudObject cloudObject) {
        AvroDatumFactory datumFactory;
        String schemaString = Structs.getString((Map<String, Object>)((Object)cloudObject), SCHEMA_FIELD);
        Schema.Parser parser = new Schema.Parser();
        Schema schema = parser.parse(schemaString);
        if (cloudObject.containsKey(TYPE_FIELD)) {
            try {
                String className = Structs.getString((Map<String, Object>)((Object)cloudObject), TYPE_FIELD);
                Class<?> type = Class.forName(className);
                boolean useReflectApi = Structs.getBoolean((Map<String, Object>)((Object)cloudObject), REFLECT_API_FIELD);
                datumFactory = AvroDatumFactory.of(type, (boolean)useReflectApi);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException(e);
            }
        } else {
            byte[] deserializedDatumFactory = StringUtils.jsonStringToByteArray((String)Structs.getString((Map<String, Object>)((Object)cloudObject), DATUM_FACTORY_FIELD));
            datumFactory = (AvroDatumFactory)SerializableUtils.deserializeFromByteArray((byte[])deserializedDatumFactory, (String)DATUM_FACTORY_FIELD);
        }
        return AvroCoder.of((AvroDatumFactory)datumFactory, (Schema)schema);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized AvroCoder> getSupportedClass() {
        return AvroCoder.class;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized String cloudObjectClassName() {
        return CloudObject.forClass(AvroCoder.class).getClassName();
    }
}

