/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.models;

import com.azure.core.models.GeoArray;
import com.azure.core.models.GeoBoundingBox;
import com.azure.core.models.GeoObject;
import com.azure.core.models.GeoObjectType;
import com.azure.core.models.GeoPoint;
import com.azure.core.models.GeoPosition;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class GeoPointCollection
extends GeoObject {
    private final List<GeoPoint> points;

    public GeoPointCollection(List<GeoPoint> points) {
        this(points, null, null);
    }

    public GeoPointCollection(List<GeoPoint> points, GeoBoundingBox boundingBox, Map<String, Object> customProperties) {
        super(boundingBox, customProperties);
        Objects.requireNonNull(points, "'points' cannot be null.");
        this.points = Collections.unmodifiableList(new ArrayList<GeoPoint>(points));
    }

    public List<GeoPoint> getPoints() {
        return this.points;
    }

    GeoArray<GeoPosition> getCoordinates() {
        return new GeoArray<GeoPosition>(this);
    }

    @Override
    public GeoObjectType getType() {
        return GeoObjectType.MULTI_POINT;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.points, super.hashCode());
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof GeoPointCollection)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        GeoPointCollection other = (GeoPointCollection)obj;
        return super.equals(obj) && Objects.equals(this.points, other.points);
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject().writeStringField("type", GeoObjectType.MULTI_POINT.toString()).writeArrayField("coordinates", this.points, (writer, geoPoint) -> geoPoint.getCoordinates().toJson((JsonWriter)writer)).writeJsonField("bbox", (JsonSerializable)this.getBoundingBox());
        return this.writeCustomProperties(jsonWriter).writeEndObject();
    }

    public static GeoPointCollection fromJson(JsonReader jsonReader) throws IOException {
        return (GeoPointCollection)jsonReader.readObject(reader -> {
            ArrayList<GeoPoint> points = null;
            GeoBoundingBox boundingBox = null;
            LinkedHashMap<String, Object> customProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("type".equals(fieldName)) {
                    String type = reader.getString();
                    if (GeoObjectType.MULTI_POINT.toString().equals(type)) continue;
                    throw new IllegalStateException("'type' was expected to be non-null and equal to 'MultiPoint'. The found 'type' was '" + type + "'.");
                }
                if ("coordinates".equals(fieldName)) {
                    List positions = reader.readArray(GeoPosition::fromJson);
                    points = new ArrayList<GeoPoint>(positions.size());
                    for (GeoPosition position : positions) {
                        points.add(new GeoPoint(position));
                    }
                    continue;
                }
                if ("bbox".equals(fieldName)) {
                    boundingBox = GeoBoundingBox.fromJson(reader);
                    continue;
                }
                if (customProperties == null) {
                    customProperties = new LinkedHashMap<String, Object>();
                }
                customProperties.put(fieldName, reader.readUntyped());
            }
            return new GeoPointCollection(points, boundingBox, customProperties);
        });
    }
}

