/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.compiler;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import org.drools.compiler.compiler.DroolsError;
import org.drools.compiler.compiler.SerializableDroolsError;
import org.kie.internal.builder.KnowledgeBuilderError;
import org.kie.internal.builder.KnowledgeBuilderErrors;

public class PackageBuilderErrors
extends ArrayList<KnowledgeBuilderError>
implements KnowledgeBuilderErrors,
Externalizable {
    private DroolsError[] errors;

    public PackageBuilderErrors() {
    }

    public PackageBuilderErrors(DroolsError[] errors) {
        super(errors.length);
        this.errors = errors;
        for (DroolsError error : errors) {
            this.add(error);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        SerializableDroolsError[] temp = (SerializableDroolsError[])in.readObject();
        this.errors = temp;
        for (SerializableDroolsError error : temp) {
            this.add(error);
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        if (!this.errors.getClass().getComponentType().equals(SerializableDroolsError.class)) {
            SerializableDroolsError[] temp = new SerializableDroolsError[this.errors.length];
            int i = 0;
            for (DroolsError error : this.errors) {
                temp[i] = new SerializableDroolsError(error);
            }
            out.writeObject(temp);
        } else {
            out.writeObject(this.errors);
        }
    }

    public DroolsError[] getErrors() {
        return this.errors;
    }

    @Override
    public boolean isEmpty() {
        return this.errors.length == 0;
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder();
        int length = this.errors.length;
        for (int i = 0; i < length; ++i) {
            buf.append(this.errors[i]);
            buf.append("\n");
        }
        return buf.toString();
    }
}

