/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.reactor;

import org.apache.qpid.proton.engine.BaseHandler;
import org.apache.qpid.proton.engine.Endpoint;
import org.apache.qpid.proton.engine.EndpointState;
import org.apache.qpid.proton.engine.Event;
import org.apache.qpid.proton.engine.Link;

public class Handshaker
extends BaseHandler {
    private void open(Endpoint endpoint) {
        if (endpoint.getLocalState() == EndpointState.UNINITIALIZED) {
            endpoint.open();
        }
    }

    private void close(Endpoint endpoint) {
        if (endpoint.getLocalState() != EndpointState.CLOSED) {
            endpoint.close();
        }
    }

    @Override
    public void onConnectionRemoteOpen(Event event) {
        this.open(event.getConnection());
    }

    @Override
    public void onSessionRemoteOpen(Event event) {
        this.open(event.getSession());
    }

    @Override
    public void onLinkRemoteOpen(Event event) {
        Link link = event.getLink();
        if (link.getLocalState() == EndpointState.UNINITIALIZED) {
            if (link.getRemoteSource() != null) {
                link.setSource(link.getRemoteSource().copy());
            }
            if (link.getRemoteTarget() != null) {
                link.setTarget(link.getRemoteTarget().copy());
            }
        }
        this.open(link);
    }

    @Override
    public void onConnectionRemoteClose(Event event) {
        this.close(event.getConnection());
    }

    @Override
    public void onSessionRemoteClose(Event event) {
        this.close(event.getSession());
    }

    @Override
    public void onLinkRemoteClose(Event event) {
        this.close(event.getLink());
    }
}

