/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.optimizer.plan;

import org.apache.flink.api.common.distributions.DataDistribution;
import org.apache.flink.api.common.functions.Partitioner;
import org.apache.flink.api.common.operators.util.FieldList;
import org.apache.flink.api.common.typeutils.TypeComparatorFactory;
import org.apache.flink.api.common.typeutils.TypeSerializerFactory;
import org.apache.flink.optimizer.CompilerException;
import org.apache.flink.optimizer.dag.EstimateProvider;
import org.apache.flink.optimizer.dag.TempMode;
import org.apache.flink.optimizer.dataproperties.GlobalProperties;
import org.apache.flink.optimizer.dataproperties.LocalProperties;
import org.apache.flink.optimizer.dataproperties.RequestedGlobalProperties;
import org.apache.flink.optimizer.dataproperties.RequestedLocalProperties;
import org.apache.flink.optimizer.plan.BinaryUnionPlanNode;
import org.apache.flink.optimizer.plan.PlanNode;
import org.apache.flink.optimizer.plandump.DumpableConnection;
import org.apache.flink.optimizer.util.Utils;
import org.apache.flink.runtime.io.network.DataExchangeMode;
import org.apache.flink.runtime.operators.shipping.ShipStrategyType;
import org.apache.flink.runtime.operators.util.LocalStrategy;
import org.apache.flink.util.Preconditions;

public class Channel
implements EstimateProvider,
Cloneable,
DumpableConnection<PlanNode> {
    private PlanNode source;
    private PlanNode target;
    private ShipStrategyType shipStrategy = ShipStrategyType.NONE;
    private DataExchangeMode dataExchangeMode;
    private LocalStrategy localStrategy = LocalStrategy.NONE;
    private FieldList shipKeys;
    private FieldList localKeys;
    private boolean[] shipSortOrder;
    private boolean[] localSortOrder;
    private RequestedGlobalProperties requiredGlobalProps;
    private RequestedLocalProperties requiredLocalProps;
    private GlobalProperties globalProps;
    private LocalProperties localProps;
    private TypeSerializerFactory<?> serializer;
    private TypeComparatorFactory<?> shipStrategyComparator;
    private TypeComparatorFactory<?> localStrategyComparator;
    private DataDistribution dataDistribution;
    private Partitioner<?> partitioner;
    private TempMode tempMode;
    private double relativeTempMemory;
    private double relativeMemoryLocalStrategy;
    private int replicationFactor = 1;

    public Channel(PlanNode sourceNode) {
        this(sourceNode, null);
    }

    public Channel(PlanNode sourceNode, TempMode tempMode) {
        this.source = sourceNode;
        this.tempMode = tempMode == null ? TempMode.NONE : tempMode;
    }

    public PlanNode getSource() {
        return this.source;
    }

    public void setSource(PlanNode source) {
        this.source = source;
    }

    public void setTarget(PlanNode target) {
        this.target = target;
    }

    public PlanNode getTarget() {
        return this.target;
    }

    public void setShipStrategy(ShipStrategyType strategy, DataExchangeMode dataExchangeMode) {
        this.setShipStrategy(strategy, null, null, null, dataExchangeMode);
    }

    public void setShipStrategy(ShipStrategyType strategy, FieldList keys, DataExchangeMode dataExchangeMode) {
        this.setShipStrategy(strategy, keys, null, null, dataExchangeMode);
    }

    public void setShipStrategy(ShipStrategyType strategy, FieldList keys, boolean[] sortDirection, DataExchangeMode dataExchangeMode) {
        this.setShipStrategy(strategy, keys, sortDirection, null, dataExchangeMode);
    }

    public void setShipStrategy(ShipStrategyType strategy, FieldList keys, Partitioner<?> partitioner, DataExchangeMode dataExchangeMode) {
        this.setShipStrategy(strategy, keys, null, partitioner, dataExchangeMode);
    }

    public void setShipStrategy(ShipStrategyType strategy, FieldList keys, boolean[] sortDirection, Partitioner<?> partitioner, DataExchangeMode dataExchangeMode) {
        this.shipStrategy = strategy;
        this.shipKeys = keys;
        this.shipSortOrder = sortDirection;
        this.partitioner = partitioner;
        this.dataExchangeMode = dataExchangeMode;
        this.globalProps = null;
    }

    public void setDataExchangeMode(DataExchangeMode dataExchangeMode) {
        this.dataExchangeMode = (DataExchangeMode)Preconditions.checkNotNull((Object)dataExchangeMode);
    }

    public DataExchangeMode getDataExchangeMode() {
        return this.dataExchangeMode;
    }

    @Override
    public ShipStrategyType getShipStrategy() {
        return this.shipStrategy;
    }

    public FieldList getShipStrategyKeys() {
        return this.shipKeys;
    }

    public boolean[] getShipStrategySortOrder() {
        return this.shipSortOrder;
    }

    public void setLocalStrategy(LocalStrategy strategy) {
        this.setLocalStrategy(strategy, null, null);
    }

    public void setLocalStrategy(LocalStrategy strategy, FieldList keys, boolean[] sortDirection) {
        this.localStrategy = strategy;
        this.localKeys = keys;
        this.localSortOrder = sortDirection;
        this.localProps = null;
    }

    public LocalStrategy getLocalStrategy() {
        return this.localStrategy;
    }

    public FieldList getLocalStrategyKeys() {
        return this.localKeys;
    }

    public boolean[] getLocalStrategySortOrder() {
        return this.localSortOrder;
    }

    public void setDataDistribution(DataDistribution dataDistribution) {
        this.dataDistribution = dataDistribution;
    }

    public DataDistribution getDataDistribution() {
        return this.dataDistribution;
    }

    public Partitioner<?> getPartitioner() {
        return this.partitioner;
    }

    public TempMode getTempMode() {
        return this.tempMode;
    }

    public void setTempMode(TempMode tempMode) {
        this.tempMode = tempMode;
    }

    public double getRelativeTempMemory() {
        return this.relativeTempMemory;
    }

    public void setRelativeTempMemory(double relativeTempMemory) {
        this.relativeTempMemory = relativeTempMemory;
    }

    public void setReplicationFactor(int factor) {
        this.replicationFactor = factor;
    }

    public int getReplicationFactor() {
        return this.replicationFactor;
    }

    public TypeSerializerFactory<?> getSerializer() {
        return this.serializer;
    }

    public void setSerializer(TypeSerializerFactory<?> serializer) {
        this.serializer = serializer;
    }

    public TypeComparatorFactory<?> getShipStrategyComparator() {
        return this.shipStrategyComparator;
    }

    public void setShipStrategyComparator(TypeComparatorFactory<?> shipStrategyComparator) {
        this.shipStrategyComparator = shipStrategyComparator;
    }

    public TypeComparatorFactory<?> getLocalStrategyComparator() {
        return this.localStrategyComparator;
    }

    public void setLocalStrategyComparator(TypeComparatorFactory<?> localStrategyComparator) {
        this.localStrategyComparator = localStrategyComparator;
    }

    public double getRelativeMemoryLocalStrategy() {
        return this.relativeMemoryLocalStrategy;
    }

    public void setRelativeMemoryLocalStrategy(double relativeMemoryLocalStrategy) {
        this.relativeMemoryLocalStrategy = relativeMemoryLocalStrategy;
    }

    public boolean isOnDynamicPath() {
        return this.source.isOnDynamicPath();
    }

    public int getCostWeight() {
        return this.source.getCostWeight();
    }

    @Override
    public long getEstimatedOutputSize() {
        long estimate = this.source.template.getEstimatedOutputSize();
        return estimate < 0L ? estimate : estimate * (long)this.replicationFactor;
    }

    @Override
    public long getEstimatedNumRecords() {
        long estimate = this.source.template.getEstimatedNumRecords();
        return estimate < 0L ? estimate : estimate * (long)this.replicationFactor;
    }

    @Override
    public float getEstimatedAvgWidthPerOutputRecord() {
        return this.source.template.getEstimatedAvgWidthPerOutputRecord();
    }

    public RequestedGlobalProperties getRequiredGlobalProps() {
        return this.requiredGlobalProps;
    }

    public void setRequiredGlobalProps(RequestedGlobalProperties requiredGlobalProps) {
        this.requiredGlobalProps = requiredGlobalProps;
    }

    public RequestedLocalProperties getRequiredLocalProps() {
        return this.requiredLocalProps;
    }

    public void setRequiredLocalProps(RequestedLocalProperties requiredLocalProps) {
        this.requiredLocalProps = requiredLocalProps;
    }

    public GlobalProperties getGlobalProperties() {
        if (this.globalProps == null) {
            this.globalProps = this.source.getGlobalProperties().clone();
            switch (this.shipStrategy) {
                case BROADCAST: {
                    this.globalProps.clearUniqueFieldCombinations();
                    this.globalProps.setFullyReplicated();
                    break;
                }
                case PARTITION_HASH: {
                    this.globalProps.setHashPartitioned(this.shipKeys);
                    break;
                }
                case PARTITION_RANGE: {
                    this.globalProps.setRangePartitioned(Utils.createOrdering(this.shipKeys, this.shipSortOrder), this.dataDistribution);
                    break;
                }
                case FORWARD: {
                    break;
                }
                case PARTITION_RANDOM: {
                    this.globalProps.reset();
                    break;
                }
                case PARTITION_FORCED_REBALANCE: {
                    this.globalProps.setForcedRebalanced();
                    break;
                }
                case PARTITION_CUSTOM: {
                    this.globalProps.setCustomPartitioned(this.shipKeys, this.partitioner);
                    break;
                }
                case NONE: {
                    throw new CompilerException("Cannot produce GlobalProperties before ship strategy is set.");
                }
            }
        }
        return this.globalProps;
    }

    public LocalProperties getLocalProperties() {
        if (this.localProps == null) {
            this.computeLocalPropertiesAfterShippingOnly();
            switch (this.localStrategy) {
                case NONE: {
                    break;
                }
                case SORT: 
                case COMBININGSORT: {
                    this.localProps = LocalProperties.forOrdering(Utils.createOrdering(this.localKeys, this.localSortOrder));
                    break;
                }
                default: {
                    throw new CompilerException("Unsupported local strategy for channel.");
                }
            }
        }
        return this.localProps;
    }

    private void computeLocalPropertiesAfterShippingOnly() {
        switch (this.shipStrategy) {
            case BROADCAST: 
            case PARTITION_HASH: 
            case PARTITION_RANGE: 
            case PARTITION_RANDOM: 
            case PARTITION_FORCED_REBALANCE: 
            case PARTITION_CUSTOM: {
                this.localProps = new LocalProperties();
                break;
            }
            case FORWARD: {
                this.localProps = this.source.getLocalProperties();
                break;
            }
            case NONE: {
                throw new CompilerException("ShipStrategy has not yet been set.");
            }
            default: {
                throw new CompilerException("Unknown ShipStrategy.");
            }
        }
    }

    public void adjustGlobalPropertiesForFullParallelismChange() {
        if (this.shipStrategy == null || this.shipStrategy == ShipStrategyType.NONE) {
            throw new IllegalStateException("Cannot adjust channel for parallelism change before the ship strategy is set.");
        }
        if (this.globalProps == null) {
            this.getGlobalProperties();
        }
        switch (this.shipStrategy) {
            case FORWARD: {
                throw new CompilerException("Cannot use FORWARD strategy between operations with different number of parallel instances.");
            }
            case BROADCAST: 
            case PARTITION_HASH: 
            case PARTITION_RANGE: 
            case PARTITION_RANDOM: 
            case PARTITION_FORCED_REBALANCE: 
            case PARTITION_CUSTOM: 
            case NONE: {
                return;
            }
        }
        throw new CompilerException("Unrecognized Ship Strategy Type: " + this.shipStrategy);
    }

    public void swapUnionNodes(PlanNode newUnionNode) {
        if (!(this.source instanceof BinaryUnionPlanNode)) {
            throw new IllegalStateException();
        }
        this.source = newUnionNode;
    }

    public int getMaxDepth() {
        return this.source.getOptimizerNode().getMaxDepth() + 1;
    }

    public String toString() {
        return "Channel (" + this.source + (this.target == null ? Character.valueOf(')') : ") -> (" + this.target + ')') + '[' + this.shipStrategy + "] [" + this.localStrategy + "] " + (this.tempMode == null || this.tempMode == TempMode.NONE ? "{NO-TEMP}" : this.tempMode);
    }

    public Channel clone() {
        try {
            return (Channel)super.clone();
        }
        catch (CloneNotSupportedException cnsex) {
            throw new RuntimeException(cnsex);
        }
    }
}

