/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.logaggregation.filecontroller;

import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.records.ApplicationAccessType;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.NodeId;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class LogAggregationFileControllerContext {
    private final boolean logAggregationInRolling;
    private final long rollingMonitorInterval;
    private final Path remoteNodeLogFileForApp;
    private final NodeId nodeId;
    private final UserGroupInformation userUgi;
    private final ApplicationId appId;
    private final Path remoteNodeTmpLogFileForApp;
    private final Map<ApplicationAccessType, String> appAcls;
    private int logAggregationTimes = 0;
    private int cleanOldLogsTimes = 0;
    private boolean uploadedLogsInThisCycle;
    private long logUploadedTimeStamp;

    public LogAggregationFileControllerContext(Path remoteNodeLogFileForApp, Path remoteNodeTmpLogFileForApp, boolean logAggregationInRolling, long rollingMonitorInterval, ApplicationId appId, Map<ApplicationAccessType, String> appAcls, NodeId nodeId, UserGroupInformation userUgi) {
        this.remoteNodeLogFileForApp = remoteNodeLogFileForApp;
        this.remoteNodeTmpLogFileForApp = remoteNodeTmpLogFileForApp;
        this.logAggregationInRolling = logAggregationInRolling;
        this.rollingMonitorInterval = rollingMonitorInterval;
        this.nodeId = nodeId;
        this.appId = appId;
        this.appAcls = appAcls;
        this.userUgi = userUgi;
    }

    public boolean isUploadedLogsInThisCycle() {
        return this.uploadedLogsInThisCycle;
    }

    public void setUploadedLogsInThisCycle(boolean uploadedLogsInThisCycle) {
        this.uploadedLogsInThisCycle = uploadedLogsInThisCycle;
    }

    public Path getRemoteNodeLogFileForApp() {
        return this.remoteNodeLogFileForApp;
    }

    public long getRollingMonitorInterval() {
        return this.rollingMonitorInterval;
    }

    public boolean isLogAggregationInRolling() {
        return this.logAggregationInRolling;
    }

    public long getLogUploadTimeStamp() {
        return this.logUploadedTimeStamp;
    }

    public void setLogUploadTimeStamp(long uploadTimeStamp) {
        this.logUploadedTimeStamp = uploadTimeStamp;
    }

    public NodeId getNodeId() {
        return this.nodeId;
    }

    public UserGroupInformation getUserUgi() {
        return this.userUgi;
    }

    public ApplicationId getAppId() {
        return this.appId;
    }

    public Path getRemoteNodeTmpLogFileForApp() {
        return this.remoteNodeTmpLogFileForApp;
    }

    public void increLogAggregationTimes() {
        ++this.logAggregationTimes;
    }

    public void increcleanupOldLogTimes() {
        ++this.cleanOldLogsTimes;
    }

    public int getLogAggregationTimes() {
        return this.logAggregationTimes;
    }

    public int getCleanOldLogsTimes() {
        return this.cleanOldLogsTimes;
    }

    public Map<ApplicationAccessType, String> getAppAcls() {
        return this.appAcls;
    }
}

