/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.core.widgets;

import java.io.OutputStream;
import java.util.Date;
import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.vfs2.FileObject;
import org.apache.hop.core.gui.plugin.GuiPlugin;
import org.apache.hop.core.gui.plugin.toolbar.GuiToolbarElement;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaInteger;
import org.apache.hop.core.row.value.ValueMetaString;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.dialog.MessageBox;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.util.EnvironmentUtils;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFCreationHelper;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;

@GuiPlugin
public class TableViewExportToExcelToolbarButton {
    private static final String ID_TOOLBAR_EXPORT_EXCEL = "tableview-toolbar-30000-export-to-excel";

    @GuiToolbarElement(root="TableView-Toolbar", id="tableview-toolbar-30000-export-to-excel", toolTip="i18n::ExcelWidget.ExportToolbarButton.ToolTip", separator=true, image="excelwriter.svg")
    public static void copyToNewGoogleDocsSpreadsheet(TableView tableView) {
        Shell shell = tableView.getShell();
        Cursor oldCursor = shell.getCursor();
        shell.setCursor(shell.getDisplay().getSystemCursor(1));
        try (XSSFWorkbook workbook = new XSSFWorkbook();){
            FileObject fileObject;
            String filename;
            XSSFSheet sheet = workbook.createSheet("Apache Hop data export");
            XSSFCellStyle headerStyle = workbook.createCellStyle();
            headerStyle.setBorderBottom(BorderStyle.DOUBLE);
            XSSFFont font = workbook.createFont();
            font.setBold(true);
            headerStyle.setFont((Font)font);
            int rowNr = 0;
            XSSFRow row = sheet.createRow(rowNr++);
            int colNr = 0;
            Cell cell = row.createCell(colNr++);
            cell.setCellValue("#");
            cell.setCellStyle((CellStyle)headerStyle);
            for (ColumnInfo columnInfo : tableView.getColumns()) {
                cell = row.createCell(colNr++);
                cell.setCellValue(columnInfo.getName());
                cell.setCellStyle((CellStyle)headerStyle);
            }
            ValueMetaString cellValueMeta = new ValueMetaString("cell");
            HashMap<Integer, CellStyle> columnStyles = new HashMap<Integer, CellStyle>();
            XSSFCreationHelper creationHelper = workbook.getCreationHelper();
            for (TableItem item : tableView.getNonEmptyItems()) {
                row = sheet.createRow(rowNr++);
                colNr = 0;
                for (int i = 0; i < tableView.getColumns().length + 1; ++i) {
                    ValueMetaInteger valueMeta;
                    CellStyle cellStyle = (CellStyle)columnStyles.get(i);
                    boolean storeStyle = false;
                    if (i == 0) {
                        valueMeta = new ValueMetaInteger("#");
                        valueMeta.setConversionMask("#");
                    } else {
                        valueMeta = tableView.getColumns()[i - 1].getValueMeta();
                    }
                    String string = item.getText(i);
                    cell = row.createCell(colNr++);
                    if (StringUtils.isEmpty((String)string) || "<null>".equals(string)) continue;
                    if (valueMeta == null) {
                        cell.setCellValue(string);
                        continue;
                    }
                    cellValueMeta.setConversionMask(valueMeta.getConversionMask());
                    Object object = valueMeta.convertData((IValueMeta)cellValueMeta, (Object)string);
                    switch (valueMeta.getType()) {
                        case 5: {
                            cell.setCellValue((double)((Long)object).longValue());
                            break;
                        }
                        case 1: {
                            cell.setCellValue(((Double)object).doubleValue());
                            break;
                        }
                        case 3: {
                            cell.setCellValue((Date)object);
                            if (cellStyle != null) break;
                            storeStyle = true;
                            cellStyle = workbook.createCellStyle();
                            cellStyle.setDataFormat(creationHelper.createDataFormat().getFormat("yyyy/m/d h:mm:ss"));
                            break;
                        }
                        case 4: {
                            cell.setCellValue(((Boolean)object).booleanValue());
                            break;
                        }
                        default: {
                            cell.setCellValue(string);
                        }
                    }
                    if (cellStyle == null) continue;
                    cell.setCellStyle(cellStyle);
                    if (!storeStyle) continue;
                    columnStyles.put(i, cellStyle);
                }
            }
            for (int column = 0; column < tableView.getColumns().length + 1; ++column) {
                sheet.autoSizeColumn(column);
            }
            if (EnvironmentUtils.getInstance().isWeb()) {
                LogChannel.UI.logBasic("Asking where to save the Excel file...");
                filename = BaseDialog.presentFileDialog((Shell)shell, (String[])new String[]{"*.xlsx"}, (String[])new String[]{"Excel XLSX files"}, (boolean)true);
                if (StringUtils.isEmpty((String)filename)) {
                    return;
                }
                fileObject = HopVfs.getFileObject((String)filename);
            } else {
                fileObject = HopVfs.createTempFile((String)"apache-hop-table-export", (String)".xlsx", (String)System.getProperty("java.io.tmpdir"));
            }
            filename = HopVfs.getFilename((FileObject)fileObject);
            LogChannel.UI.logBasic("Saving to file: " + filename);
            try (OutputStream outputStream = HopVfs.getOutputStream((FileObject)fileObject, (boolean)false);){
                workbook.write(outputStream);
            }
            shell.setCursor(oldCursor);
            EnvironmentUtils.getInstance().openUrl(filename);
            if (EnvironmentUtils.getInstance().isWeb()) {
                MessageBox messageBox = new MessageBox(shell, 34);
                messageBox.setText("File written");
                messageBox.setMessage("The Excel file was written to: " + filename);
                messageBox.open();
            }
        }
        catch (Throwable e) {
            shell.setCursor(oldCursor);
            new ErrorDialog(shell, "Error", "Error exporting rows to a new Excel file", e);
        }
    }
}

