/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.protocol.internal.request.query;

import com.datastax.dse.protocol.internal.request.query.ContinuousPagingOptions;
import com.datastax.dse.protocol.internal.request.query.DseQueryOptions;
import com.datastax.oss.protocol.internal.PrimitiveCodec;
import com.datastax.oss.protocol.internal.PrimitiveSizes;
import com.datastax.oss.protocol.internal.request.query.QueryOptions;
import com.datastax.oss.protocol.internal.request.query.Values;
import com.datastax.oss.protocol.internal.util.Flags;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class DseQueryOptionsCodec
extends QueryOptions.Codec {
    public DseQueryOptionsCodec(int protocolVersion) {
        super(protocolVersion);
        assert (protocolVersion >= 65);
    }

    @Override
    public <B> void encode(B dest, QueryOptions options, PrimitiveCodec<B> encoder) {
        ContinuousPagingOptions continuousPagingOptions;
        encoder.writeUnsignedShort(options.consistency, dest);
        encoder.writeInt(options.flags, dest);
        if (Flags.contains(options.flags, 1)) {
            if (Flags.contains(options.flags, 64)) {
                Values.writeNamedValues(options.namedValues, dest, encoder);
            } else {
                Values.writePositionalValues(options.positionalValues, dest, encoder);
            }
        }
        if (Flags.contains(options.flags, 4)) {
            encoder.writeInt(options.pageSize, dest);
        }
        if (Flags.contains(options.flags, 8)) {
            encoder.writeBytes(options.pagingState, dest);
        }
        if (Flags.contains(options.flags, 16)) {
            encoder.writeUnsignedShort(options.serialConsistency, dest);
        }
        if (Flags.contains(options.flags, 32)) {
            encoder.writeLong(options.defaultTimestamp, dest);
        }
        if (Flags.contains(options.flags, 128)) {
            encoder.writeString(options.keyspace, dest);
        }
        if (options instanceof DseQueryOptions && (continuousPagingOptions = ((DseQueryOptions)options).continuousPagingOptions) != null) {
            encoder.writeInt(continuousPagingOptions.maxPages, dest);
            encoder.writeInt(continuousPagingOptions.pagesPerSecond, dest);
            if (this.protocolVersion >= 66) {
                encoder.writeInt(continuousPagingOptions.nextPages, dest);
            }
        }
    }

    @Override
    public int encodedSize(QueryOptions options) {
        ContinuousPagingOptions continuousPagingOptions;
        int size = 6;
        if (Flags.contains(options.flags, 1)) {
            size = Flags.contains(options.flags, 64) ? (size += Values.sizeOfNamedValues(options.namedValues)) : (size += Values.sizeOfPositionalValues(options.positionalValues));
        }
        if (Flags.contains(options.flags, 4)) {
            size += 4;
        }
        if (Flags.contains(options.flags, 8)) {
            size += PrimitiveSizes.sizeOfBytes(options.pagingState);
        }
        if (Flags.contains(options.flags, 16)) {
            size += 2;
        }
        if (Flags.contains(options.flags, 32)) {
            size += 8;
        }
        if (Flags.contains(options.flags, 128)) {
            size += PrimitiveSizes.sizeOfString(options.keyspace);
        }
        if (options instanceof DseQueryOptions && (continuousPagingOptions = ((DseQueryOptions)options).continuousPagingOptions) != null) {
            size += 4 * (this.protocolVersion >= 66 ? 3 : 2);
        }
        return size;
    }

    @Override
    public <B> QueryOptions decode(B source, PrimitiveCodec<B> decoder) {
        int consistency = decoder.readUnsignedShort(source);
        int flags = this.protocolVersion >= 5 ? decoder.readInt(source) : (int)decoder.readByte(source);
        List<ByteBuffer> positionalValues = Collections.emptyList();
        Map<String, ByteBuffer> namedValues = Collections.emptyMap();
        if (Flags.contains(flags, 1)) {
            if (Flags.contains(flags, 64)) {
                namedValues = Values.readNamedValues(source, decoder);
            } else {
                positionalValues = Values.readPositionalValues(source, decoder);
            }
        }
        boolean skipMetadata = Flags.contains(flags, 2);
        int pageSize = Flags.contains(flags, 4) ? decoder.readInt(source) : -1;
        ByteBuffer pagingState = Flags.contains(flags, 8) ? decoder.readBytes(source) : null;
        int serialConsistency = Flags.contains(flags, 16) ? decoder.readUnsignedShort(source) : 8;
        long defaultTimestamp = Flags.contains(flags, 32) ? decoder.readLong(source) : Long.MIN_VALUE;
        String keyspace = Flags.contains(flags, 128) ? decoder.readString(source) : null;
        boolean isPageSizeInBytes = Flags.contains(flags, 0x40000000);
        ContinuousPagingOptions continuousPagingOptions = null;
        if (Flags.contains(flags, Integer.MIN_VALUE)) {
            int maxPages = decoder.readInt(source);
            int pagesPerSecond = decoder.readInt(source);
            int nextPages = this.protocolVersion >= 66 ? decoder.readInt(source) : -1;
            continuousPagingOptions = new ContinuousPagingOptions(maxPages, pagesPerSecond, nextPages);
        }
        return new DseQueryOptions(flags, consistency, positionalValues, namedValues, skipMetadata, pageSize, pagingState, serialConsistency, defaultTimestamp, keyspace, isPageSizeInBytes, continuousPagingOptions);
    }
}

