/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.util.construction;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.sdk.util.construction.ArtifactResolver;
import org.apache.beam.sdk.util.construction.BeamUrns;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableMap;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Lists;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class DefaultArtifactResolver
implements ArtifactResolver {
    public static final @UnknownKeyFor @NonNull @Initialized ArtifactResolver INSTANCE = new DefaultArtifactResolver();
    private @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized ArtifactResolver.ResolutionFn> fns = Lists.newArrayList((Object[])new ArtifactResolver.ResolutionFn[]{info -> {
        if (BeamUrns.getUrn(RunnerApi.StandardArtifacts.Types.FILE).equals(info.getTypeUrn())) {
            return Optional.of(ImmutableList.of((Object)info));
        }
        return Optional.empty();
    }});
    private @UnknownKeyFor @NonNull @Initialized Function< @UnknownKeyFor @NonNull @Initialized RunnerApi.ArtifactInformation, @UnknownKeyFor @NonNull @Initialized Stream< @UnknownKeyFor @NonNull @Initialized RunnerApi.ArtifactInformation>> resolver = info -> {
        for (ArtifactResolver.ResolutionFn fn : Lists.reverse(this.regesteredFns())) {
            Optional<List<RunnerApi.ArtifactInformation>> resolved = fn.resolve((RunnerApi.ArtifactInformation)info);
            if (!resolved.isPresent()) continue;
            return resolved.get().stream();
        }
        throw new RuntimeException(String.format("Cannot resolve artifact information: %s", info));
    };

    private synchronized @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized ArtifactResolver.ResolutionFn> regesteredFns() {
        return ImmutableList.copyOf(this.fns);
    }

    @Override
    public synchronized void register(@UnknownKeyFor @NonNull @Initialized ArtifactResolver.ResolutionFn fn) {
        this.fns.add(fn);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized List< @UnknownKeyFor @NonNull @Initialized RunnerApi.ArtifactInformation> resolveArtifacts(@UnknownKeyFor @NonNull @Initialized List< @UnknownKeyFor @NonNull @Initialized RunnerApi.ArtifactInformation> artifacts) {
        for (ArtifactResolver.ResolutionFn fn : Lists.reverse(this.regesteredFns())) {
            ArrayList<RunnerApi.ArtifactInformation> moreResolved = new ArrayList<RunnerApi.ArtifactInformation>();
            for (RunnerApi.ArtifactInformation artifact : artifacts) {
                Optional<List<RunnerApi.ArtifactInformation>> resolved = fn.resolve(artifact);
                if (resolved.isPresent()) {
                    moreResolved.addAll((Collection<RunnerApi.ArtifactInformation>)resolved.get());
                    continue;
                }
                moreResolved.add(artifact);
            }
            artifacts = moreResolved;
        }
        return artifacts;
    }

    @Override
    public  @UnknownKeyFor @NonNull @Initialized RunnerApi.Pipeline resolveArtifacts( @UnknownKeyFor @NonNull @Initialized RunnerApi.Pipeline pipeline) {
        ImmutableMap.Builder environmentMapBuilder = ImmutableMap.builder();
        for (Map.Entry<String, RunnerApi.Environment> entry : pipeline.getComponents().getEnvironmentsMap().entrySet()) {
            List resolvedDependencies = entry.getValue().getDependenciesList().parallelStream().flatMap(this.resolver).collect(Collectors.toList());
            environmentMapBuilder.put((Object)entry.getKey(), (Object)entry.getValue().toBuilder().clearDependencies().addAllDependencies(resolvedDependencies).build());
        }
        return pipeline.toBuilder().setComponents(pipeline.getComponents().toBuilder().putAllEnvironments((Map<String, RunnerApi.Environment>)environmentMapBuilder.build())).build();
    }
}

