/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.util.Preconditions;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Splitter;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Maps;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class RowFilter
implements Serializable {
    private final @UnknownKeyFor @NonNull @Initialized Schema rowSchema;
    private @Nullable @UnknownKeyFor @Initialized Schema transformedSchema;
    private @Nullable @UnknownKeyFor @Initialized String onlyField;

    public RowFilter(@UnknownKeyFor @NonNull @Initialized Schema rowSchema) {
        this.rowSchema = rowSchema;
    }

    public @UnknownKeyFor @NonNull @Initialized RowFilter keep(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> fields) {
        this.checkUnconfigured();
        this.verifyNoNestedFields(fields, "keep");
        RowFilter.validateSchemaContainsFields(this.rowSchema, fields, "keep");
        this.transformedSchema = RowFilter.keepFields(this.rowSchema, fields);
        return this;
    }

    public @UnknownKeyFor @NonNull @Initialized RowFilter drop(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> fields) {
        this.checkUnconfigured();
        this.verifyNoNestedFields(fields, "drop");
        RowFilter.validateSchemaContainsFields(this.rowSchema, fields, "drop");
        this.transformedSchema = RowFilter.dropFields(this.rowSchema, fields);
        return this;
    }

    public @UnknownKeyFor @NonNull @Initialized RowFilter only(@UnknownKeyFor @NonNull @Initialized String field) {
        this.checkUnconfigured();
        this.verifyNoNestedFields(Collections.singletonList(field), "only");
        RowFilter.validateSchemaContainsFields(this.rowSchema, Collections.singletonList(field), "only");
        Schema.Field rowField = this.rowSchema.getField(field);
        org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkArgument((boolean)rowField.getType().getTypeName().equals((Object)Schema.TypeName.ROW), (String)"Expected type '%s' for field '%s', but instead got type '%s'.", (Object)((Object)Schema.TypeName.ROW), (Object)rowField.getName(), (Object)((Object)rowField.getType().getTypeName()));
        this.transformedSchema = rowField.getType().getRowSchema();
        this.onlyField = field;
        return this;
    }

    public @UnknownKeyFor @NonNull @Initialized Row filter(@UnknownKeyFor @NonNull @Initialized Row row) {
        if (this.transformedSchema == null) {
            return row;
        }
        org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkState((boolean)row.getSchema().assignableTo(this.rowSchema), (String)"Encountered Row with schema that is incompatible with this filter's schema.\nRow schema: %s\nSchema used to initialize this filter: %s", (Object)row.getSchema(), (Object)this.rowSchema);
        if (this.onlyField != null) {
            return Preconditions.checkStateNotNull(row.getRow(this.onlyField));
        }
        return (Row)org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkNotNull((Object)RowFilter.copyWithNewSchema(row, this.outputSchema()));
    }

    public @UnknownKeyFor @NonNull @Initialized Schema outputSchema() {
        return this.transformedSchema != null ? this.transformedSchema : this.rowSchema;
    }

    private void checkUnconfigured() {
        org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkState((this.transformedSchema == null ? 1 : 0) != 0, (Object)"Invalid filter configuration: Please set only one of 'keep', 'drop', or 'only'.");
    }

    private void verifyNoNestedFields(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> fields, @UnknownKeyFor @NonNull @Initialized String operation) {
        ArrayList<String> nestedFields = new ArrayList<String>();
        for (String field : fields) {
            if (!field.contains(".")) continue;
            nestedFields.add(field);
        }
        if (!nestedFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("'%s' does not support nested fields: %s", operation, nestedFields));
        }
    }

    @VisibleForTesting
    static void validateSchemaContainsFields(@UnknownKeyFor @NonNull @Initialized Schema schema, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> specifiedFields, @UnknownKeyFor @NonNull @Initialized String operation) {
        HashSet<String> notFound = new HashSet<String>();
        HashSet<String> notRowField = new HashSet<String>();
        block0: for (String field : specifiedFields) {
            List levels = Splitter.on((String)".").splitToList((CharSequence)field);
            Schema currentSchema = schema;
            for (int i = 0; i < levels.size(); ++i) {
                String currentFieldName = String.join((CharSequence)".", levels.subList(0, i + 1));
                if (!currentSchema.hasField((String)levels.get(i))) {
                    notFound.add(currentFieldName);
                    continue block0;
                }
                if (i + 1 >= levels.size()) continue;
                Schema.Field nextField = currentSchema.getField((String)levels.get(i));
                if (!nextField.getType().getTypeName().equals((Object)Schema.TypeName.ROW)) {
                    notRowField.add(currentFieldName);
                    continue block0;
                }
                currentSchema = (Schema)org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkNotNull((Object)nextField.getType().getRowSchema());
            }
        }
        if (!notFound.isEmpty() || !notRowField.isEmpty()) {
            String message = "Validation failed for '" + operation + "'.";
            if (!notFound.isEmpty()) {
                message = message + "\nRow Schema does not contain the following specified fields: " + notFound;
            }
            if (!notRowField.isEmpty()) {
                message = message + "\nThe following specified fields are not of type Row. Their nested fields could not be reached: " + notRowField;
            }
            throw new IllegalArgumentException(message);
        }
    }

    @VisibleForTesting
    static @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String>> getFieldTree(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> fields) {
        HashMap fieldTree = Maps.newHashMap();
        for (String field : fields) {
            List components = Splitter.on((String)".").splitToList((CharSequence)field);
            String root = (String)components.get(0);
            fieldTree.computeIfAbsent(root, r -> new ArrayList());
            if (components.size() <= 1) continue;
            String nestedFields = String.join((CharSequence)".", components.subList(1, components.size()));
            ((List)org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkNotNull((Object)((List)fieldTree.get(root)))).add(nestedFields);
        }
        return fieldTree;
    }

    @VisibleForTesting
    static @Nullable @UnknownKeyFor @Initialized Row copyWithNewSchema(@Nullable @UnknownKeyFor @Initialized Row row, @UnknownKeyFor @NonNull @Initialized Schema newSchema) {
        if (row == null) {
            return null;
        }
        HashMap<String, Object> values = new HashMap<String, Object>(newSchema.getFieldCount());
        for (Schema.Field field : newSchema.getFields()) {
            String name = field.getName();
            Object value = row.getValue(name);
            if (field.getType().getTypeName().equals((Object)Schema.TypeName.ROW)) {
                Schema nestedRowSchema = (Schema)org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkNotNull((Object)field.getType().getRowSchema());
                value = RowFilter.copyWithNewSchema(row.getRow(name), nestedRowSchema);
            }
            if (value == null) continue;
            values.put(name, value);
        }
        return Row.withSchema(newSchema).withFieldValues(values).build();
    }

    @VisibleForTesting
    static @UnknownKeyFor @NonNull @Initialized Schema dropFields(@UnknownKeyFor @NonNull @Initialized Schema schema, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> fieldsToDrop) {
        if (fieldsToDrop.isEmpty()) {
            return schema;
        }
        ArrayList<Schema.Field> newFieldsList = new ArrayList<Schema.Field>(schema.getFields());
        Map<String, List<String>> fieldTree = RowFilter.getFieldTree(fieldsToDrop);
        for (Map.Entry<String, List<String>> fieldAndDescendents : fieldTree.entrySet()) {
            String root = fieldAndDescendents.getKey();
            List<String> nestedFields = fieldAndDescendents.getValue();
            Schema.Field fieldToRemove = schema.getField(root);
            Schema.FieldType typeToRemove = fieldToRemove.getType();
            if (nestedFields.isEmpty()) {
                newFieldsList.remove(fieldToRemove);
                continue;
            }
            org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkArgument((boolean)typeToRemove.getTypeName().equals((Object)Schema.TypeName.ROW), (String)"Expected type %s for specified nested field '%s', but instead got type %s.", (Object)((Object)Schema.TypeName.ROW), (Object)root, (Object)((Object)typeToRemove.getTypeName()));
            Schema nestedSchema = (Schema)org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkNotNull((Object)typeToRemove.getRowSchema());
            Schema newNestedSchema = RowFilter.dropFields(nestedSchema, nestedFields);
            Schema.Field modifiedField = Schema.Field.of(root, Schema.FieldType.row(newNestedSchema)).withNullable(typeToRemove.getNullable());
            newFieldsList.set(newFieldsList.indexOf(fieldToRemove), modifiedField);
        }
        return new Schema(newFieldsList);
    }

    @VisibleForTesting
    static @UnknownKeyFor @NonNull @Initialized Schema keepFields(@UnknownKeyFor @NonNull @Initialized Schema schema, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> fieldsToKeep) {
        if (fieldsToKeep.isEmpty()) {
            return schema;
        }
        ArrayList<Schema.Field> newFieldsList = new ArrayList<Schema.Field>(fieldsToKeep.size());
        Map<String, List<String>> fieldTree = RowFilter.getFieldTree(fieldsToKeep);
        for (Map.Entry<String, List<String>> fieldAndDescendents : fieldTree.entrySet()) {
            String root = fieldAndDescendents.getKey();
            List<String> nestedFields = fieldAndDescendents.getValue();
            Schema.Field fieldToKeep = schema.getField(root);
            Schema.FieldType typeToKeep = fieldToKeep.getType();
            if (!nestedFields.isEmpty()) {
                org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkArgument((boolean)typeToKeep.getTypeName().equals((Object)Schema.TypeName.ROW), (String)"Expected type %s for specified nested field '%s', but instead got type %s.", (Object)((Object)Schema.TypeName.ROW), (Object)root, (Object)((Object)typeToKeep.getTypeName()));
                Schema nestedSchema = (Schema)org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkNotNull((Object)typeToKeep.getRowSchema());
                Schema newNestedSchema = RowFilter.keepFields(nestedSchema, nestedFields);
                fieldToKeep = Schema.Field.of(root, Schema.FieldType.row(newNestedSchema)).withNullable(typeToKeep.getNullable());
            }
            newFieldsList.add(fieldToKeep);
        }
        return new Schema(newFieldsList);
    }
}

