/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.schemas.transforms.providers;

import com.google.auto.service.AutoService;
import com.google.auto.value.AutoValue;
import java.util.Collections;
import java.util.List;
import org.apache.beam.sdk.schemas.AutoValueSchema;
import org.apache.beam.sdk.schemas.annotations.DefaultSchema;
import org.apache.beam.sdk.schemas.transforms.SchemaTransform;
import org.apache.beam.sdk.schemas.transforms.SchemaTransformProvider;
import org.apache.beam.sdk.schemas.transforms.TypedSchemaTransformProvider;
import org.apache.beam.sdk.schemas.transforms.providers.AutoValue_FlattenTransformProvider_Configuration;
import org.apache.beam.sdk.transforms.Flatten;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionList;
import org.apache.beam.sdk.values.PCollectionRowTuple;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@AutoService(value={SchemaTransformProvider.class})
public class FlattenTransformProvider
extends TypedSchemaTransformProvider<Configuration> {
    protected static final @UnknownKeyFor @NonNull @Initialized String OUTPUT_ROWS_TAG = "output";

    @Override
    protected @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized Configuration> configurationClass() {
        return Configuration.class;
    }

    @Override
    protected @UnknownKeyFor @NonNull @Initialized SchemaTransform from(@UnknownKeyFor @NonNull @Initialized Configuration configuration) {
        return new SchemaTransform(){

            @Override
            public @UnknownKeyFor @NonNull @Initialized PCollectionRowTuple expand(@UnknownKeyFor @NonNull @Initialized PCollectionRowTuple input) {
                return PCollectionRowTuple.of(FlattenTransformProvider.OUTPUT_ROWS_TAG, ((PCollection)PCollectionList.of(input.expand().values()).apply(Flatten.pCollections())).setRowSchema(((PCollection)input.expand().values().iterator().next()).getSchema()));
            }
        };
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized String identifier() {
        return "beam:schematransform:org.apache.beam:yaml:flatten:v1";
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> inputCollectionNames() {
        return Collections.emptyList();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> outputCollectionNames() {
        return Collections.singletonList(OUTPUT_ROWS_TAG);
    }

    @DefaultSchema(value=AutoValueSchema.class)
    @AutoValue
    public static abstract class Configuration {
        public static @UnknownKeyFor @NonNull @Initialized Builder builder() {
            return new AutoValue_FlattenTransformProvider_Configuration.Builder();
        }

        @AutoValue.Builder
        public static abstract class Builder {
            public abstract @UnknownKeyFor @NonNull @Initialized Configuration build();
        }
    }
}

