/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.StandardCharsets;
import org.apache.beam.sdk.io.FileBasedSink;
import org.apache.beam.sdk.io.fs.ResourceId;
import org.apache.beam.sdk.options.ValueProvider;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

class TextSink<@UnknownKeyFor UserT, @UnknownKeyFor DestinationT>
extends FileBasedSink<UserT, DestinationT, String> {
    private final @Nullable @UnknownKeyFor @Initialized String header;
    private final @Nullable @UnknownKeyFor @Initialized String footer;
    private final @UnknownKeyFor @NonNull @Initialized char @UnknownKeyFor @NonNull @Initialized [] delimiter;

    TextSink(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized ResourceId> baseOutputFilename, @UnknownKeyFor @NonNull @Initialized FileBasedSink.DynamicDestinations<UserT, DestinationT, @UnknownKeyFor @NonNull @Initialized String> dynamicDestinations, @UnknownKeyFor @NonNull @Initialized char @UnknownKeyFor @NonNull @Initialized [] delimiter, @Nullable @UnknownKeyFor @Initialized String header, @Nullable @UnknownKeyFor @Initialized String footer, @UnknownKeyFor @NonNull @Initialized FileBasedSink.WritableByteChannelFactory writableByteChannelFactory) {
        super(baseOutputFilename, dynamicDestinations, writableByteChannelFactory);
        this.header = header;
        this.footer = footer;
        this.delimiter = delimiter;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized FileBasedSink.WriteOperation<DestinationT, @UnknownKeyFor @NonNull @Initialized String> createWriteOperation() {
        return new TextWriteOperation(this, this.delimiter, this.header, this.footer);
    }

    private static class TextWriter<@UnknownKeyFor DestinationT>
    extends FileBasedSink.Writer<DestinationT, String> {
        private final @Nullable @UnknownKeyFor @Initialized String header;
        private final @Nullable @UnknownKeyFor @Initialized String footer;
        private final @UnknownKeyFor @NonNull @Initialized char @UnknownKeyFor @NonNull @Initialized [] delimiter;
        private @Nullable @UnknownKeyFor @Initialized OutputStreamWriter out;

        public TextWriter(@UnknownKeyFor @NonNull @Initialized FileBasedSink.WriteOperation<DestinationT, @UnknownKeyFor @NonNull @Initialized String> writeOperation, @UnknownKeyFor @NonNull @Initialized char @UnknownKeyFor @NonNull @Initialized [] delimiter, @Nullable @UnknownKeyFor @Initialized String header, @Nullable @UnknownKeyFor @Initialized String footer) {
            super(writeOperation, "text/plain");
            this.delimiter = delimiter;
            this.header = header;
            this.footer = footer;
        }

        private void writeIfNotNull(@Nullable @UnknownKeyFor @Initialized String value) throws @UnknownKeyFor @NonNull @Initialized IOException {
            if (value != null) {
                this.writeLine(value);
            }
        }

        private void writeLine(@UnknownKeyFor @NonNull @Initialized String value) throws @UnknownKeyFor @NonNull @Initialized IOException {
            this.out.write(value);
            this.out.write(this.delimiter);
        }

        @Override
        protected void prepareWrite(@UnknownKeyFor @NonNull @Initialized WritableByteChannel channel) throws @UnknownKeyFor @NonNull @Initialized Exception {
            this.out = new OutputStreamWriter(Channels.newOutputStream(channel), StandardCharsets.UTF_8);
        }

        @Override
        protected void writeHeader() throws @UnknownKeyFor @NonNull @Initialized Exception {
            this.writeIfNotNull(this.header);
        }

        @Override
        public void write(@UnknownKeyFor @NonNull @Initialized String value) throws @UnknownKeyFor @NonNull @Initialized Exception {
            this.writeLine(value);
        }

        @Override
        protected void writeFooter() throws @UnknownKeyFor @NonNull @Initialized Exception {
            this.writeIfNotNull(this.footer);
        }

        @Override
        protected void finishWrite() throws @UnknownKeyFor @NonNull @Initialized Exception {
            this.out.flush();
        }
    }

    private static class TextWriteOperation<@UnknownKeyFor DestinationT>
    extends FileBasedSink.WriteOperation<DestinationT, String> {
        private final @Nullable @UnknownKeyFor @Initialized String header;
        private final @Nullable @UnknownKeyFor @Initialized String footer;
        private final @UnknownKeyFor @NonNull @Initialized char @UnknownKeyFor @NonNull @Initialized [] delimiter;

        private TextWriteOperation(@UnknownKeyFor @NonNull @Initialized TextSink sink, @UnknownKeyFor @NonNull @Initialized char @UnknownKeyFor @NonNull @Initialized [] delimiter, @Nullable @UnknownKeyFor @Initialized String header, @Nullable @UnknownKeyFor @Initialized String footer) {
            super(sink);
            this.header = header;
            this.footer = footer;
            this.delimiter = delimiter;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized FileBasedSink.Writer<DestinationT, @UnknownKeyFor @NonNull @Initialized String> createWriter() throws @UnknownKeyFor @NonNull @Initialized Exception {
            return new TextWriter(this, this.delimiter, this.header, this.footer);
        }
    }
}

