/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.coders;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UTFDataFormatException;
import org.apache.beam.sdk.coders.AtomicCoder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.util.VarInt;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class VarIntCoder
extends AtomicCoder<Integer> {
    private static final @UnknownKeyFor @NonNull @Initialized VarIntCoder INSTANCE = new VarIntCoder();
    private static final @UnknownKeyFor @NonNull @Initialized TypeDescriptor<@UnknownKeyFor @NonNull @Initialized Integer> TYPE_DESCRIPTOR = new TypeDescriptor<Integer>(){};

    public static @UnknownKeyFor @NonNull @Initialized VarIntCoder of() {
        return INSTANCE;
    }

    private VarIntCoder() {
    }

    @Override
    public void encode(@UnknownKeyFor @NonNull @Initialized Integer value, @UnknownKeyFor @NonNull @Initialized OutputStream outStream) throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized CoderException {
        if (value == null) {
            throw new CoderException("cannot encode a null Integer");
        }
        VarInt.encode(value, outStream);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Integer decode(@UnknownKeyFor @NonNull @Initialized InputStream inStream) throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized CoderException {
        try {
            return VarInt.decodeInt(inStream);
        }
        catch (EOFException | UTFDataFormatException exn) {
            throw new CoderException(exn);
        }
    }

    @Override
    public void verifyDeterministic() {
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean consistentWithEquals() {
        return true;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean isRegisterByteSizeObserverCheap(@UnknownKeyFor @NonNull @Initialized Integer value) {
        return true;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized TypeDescriptor<@UnknownKeyFor @NonNull @Initialized Integer> getEncodedTypeDescriptor() {
        return TYPE_DESCRIPTOR;
    }

    @Override
    protected @UnknownKeyFor @NonNull @Initialized long getEncodedElementByteSize(@UnknownKeyFor @NonNull @Initialized Integer value) throws @UnknownKeyFor @NonNull @Initialized Exception {
        if (value == null) {
            throw new CoderException("cannot encode a null Integer");
        }
        return VarInt.getLength(value.longValue());
    }
}

