/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.coders;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.IterableLikeCoder;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.sdk.values.TypeParameter;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class DequeCoder<@UnknownKeyFor T>
extends IterableLikeCoder<T, Deque<T>> {
    public static <T> @UnknownKeyFor @NonNull @Initialized DequeCoder<T> of(@UnknownKeyFor @NonNull @Initialized Coder<T> elemCoder) {
        return new DequeCoder<T>(elemCoder);
    }

    @Override
    protected @UnknownKeyFor @NonNull @Initialized Deque<T> decodeToIterable(@UnknownKeyFor @NonNull @Initialized List<T> decodedElements) {
        return new ArrayDeque<T>(decodedElements);
    }

    protected DequeCoder(@UnknownKeyFor @NonNull @Initialized Coder<T> elemCoder) {
        super(elemCoder, "Deque");
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean consistentWithEquals() {
        return this.getElemCoder().consistentWithEquals();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Object structuralValue(@UnknownKeyFor @NonNull @Initialized Deque<T> values) {
        if (this.consistentWithEquals()) {
            return values;
        }
        ArrayDeque<Object> ret = new ArrayDeque<Object>(values.size());
        for (T value : values) {
            ret.add(this.getElemCoder().structuralValue(value));
        }
        return ret;
    }

    @Override
    public void verifyDeterministic() throws @UnknownKeyFor @NonNull @Initialized Coder.NonDeterministicException {
        DequeCoder.verifyDeterministic(this, "Coder for elements of DequeCoder must be determistic", this.getElemCoder());
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized TypeDescriptor<@UnknownKeyFor @NonNull @Initialized Deque<T>> getEncodedTypeDescriptor() {
        return new TypeDescriptor<Deque<T>>(this.getClass()){}.where(new TypeParameter<T>(){}, this.getElemCoder().getEncodedTypeDescriptor());
    }
}

