/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.webservices.wsdl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.wsdl.Definition;
import javax.wsdl.Types;
import javax.wsdl.extensions.ElementExtensible;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.schema.Schema;
import javax.xml.namespace.QName;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.transforms.webservices.wsdl.DomUtils;
import org.apache.hop.pipeline.transforms.webservices.wsdl.WsdlComplexTypes;
import org.apache.hop.pipeline.transforms.webservices.wsdl.WsdlUtils;
import org.w3c.dom.Element;

public final class WsdlTypes
implements Serializable {
    private static final Class<?> PKG = WsdlTypes.class;
    private static final long serialVersionUID = 1L;
    private final String _targetNamespace;
    private final Types Types;
    private HashSet<String> _elementFormQualifiedNamespaces;
    private Map<String, String> _prefixMappings;
    private WsdlComplexTypes NamedComplexTypes;

    protected WsdlTypes(Definition wsdlDefinition) {
        this.Types = wsdlDefinition.getTypes();
        this._targetNamespace = wsdlDefinition.getTargetNamespace();
        this._prefixMappings = wsdlDefinition.getNamespaces();
        this._elementFormQualifiedNamespaces = new HashSet<String>(this.getElementFormQualifiedNamespaces());
        this.NamedComplexTypes = new WsdlComplexTypes(this);
    }

    protected Element findNamedElement(QName elementName) throws HopTransformException {
        Element namedElement = null;
        Schema s = this.getSchema(elementName.getNamespaceURI());
        if (s == null) {
            throw new HopTransformException(BaseMessages.getString(PKG, (String)"Wsdl.Error.MissingSchemaException", (Object[])new Object[]{elementName}));
        }
        Element schemaRoot = s.getElement();
        List<Element> elements = DomUtils.getChildElementsByName(schemaRoot, "element");
        for (Element e : elements) {
            String schemaElementName = e.getAttribute("name");
            if (!elementName.getLocalPart().equals(schemaElementName)) continue;
            namedElement = e;
            break;
        }
        if (namedElement == null) {
            throw new HopTransformException(BaseMessages.getString(PKG, (String)"Wsdl.Error.ElementMissingException", (Object[])new Object[]{elementName}));
        }
        return namedElement;
    }

    protected Element findNamedType(QName typeName) {
        Schema s = this.getSchema(typeName.getNamespaceURI());
        if (s == null) {
            return null;
        }
        Element schemaRoot = s.getElement();
        List<Element> types = DomUtils.getChildElementsByName(schemaRoot, "complexType");
        types.addAll(DomUtils.getChildElementsByName(schemaRoot, "simpleType"));
        Element namedType = null;
        for (Element t : types) {
            String schemaTypeName = t.getAttribute("name");
            if (!typeName.getLocalPart().equals(schemaTypeName)) continue;
            namedType = t;
            break;
        }
        return namedType;
    }

    protected WsdlComplexTypes getNamedComplexTypes() {
        return this.NamedComplexTypes;
    }

    protected String getTargetNamespace() {
        return this._targetNamespace;
    }

    protected QName getTypeQName(String type) {
        if (type.indexOf(58) > -1) {
            String prefix = type.substring(0, type.indexOf(58));
            type = type.substring(type.indexOf(58) + 1);
            return new QName(this._prefixMappings.get(prefix), type);
        }
        return new QName(this._targetNamespace, type);
    }

    protected List<ExtensibilityElement> getSchemas() {
        if (this.Types == null) {
            return Collections.emptyList();
        }
        return WsdlUtils.findExtensibilityElements((ElementExtensible)this.Types, "schema");
    }

    public boolean isElementFormQualified(String namespaceURI) {
        return this._elementFormQualifiedNamespaces.contains(namespaceURI);
    }

    private List<String> getElementFormQualifiedNamespaces() {
        ArrayList<String> namespaces = new ArrayList<String>();
        List<ExtensibilityElement> schemas = this.getSchemas();
        for (ExtensibilityElement schema : schemas) {
            String v;
            Element schemaElement = ((Schema)schema).getElement();
            if (!schemaElement.hasAttribute("elementFormDefault") || !"qualified".equalsIgnoreCase(v = schemaElement.getAttribute("elementFormDefault"))) continue;
            namespaces.add(schemaElement.getAttribute("targetNamespace"));
        }
        return namespaces;
    }

    private Schema getSchema(String targetNamespace) {
        if (this.Types == null) {
            return null;
        }
        List<ExtensibilityElement> schemas = WsdlUtils.findExtensibilityElements((ElementExtensible)this.Types, "schema");
        for (ExtensibilityElement e : schemas) {
            Element schemaRoot = ((Schema)e).getElement();
            String tns = schemaRoot.getAttribute("targetNamespace");
            if (!targetNamespace.equals(tns)) continue;
            return (Schema)e;
        }
        return null;
    }
}

