/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.jvmtool.stacktrace.codec.json;

import org.gridkit.jvmtool.stacktrace.codec.json.JfrHelper;
import org.gridkit.jvmtool.stacktrace.codec.json.JsonStreamHandler;

abstract class ThreadInfoHandler
implements JsonStreamHandler.JsonObjectHandler {
    protected String javaName;
    protected long osThreadId;
    protected long javaThreadId;

    ThreadInfoHandler() {
    }

    @Override
    public void onScalarFieldValue(String fieldName, Object val) {
        if (val != null) {
            Long id;
            if ("javaName".equals(fieldName)) {
                this.javaName = val == null ? null : String.valueOf(val);
            } else if ("osThreadId".equals(fieldName)) {
                if (val instanceof Number) {
                    this.osThreadId = ((Number)val).longValue();
                }
            } else if ("javaThreadId".equals(fieldName) && (id = JfrHelper.asLong(val)) != null) {
                this.javaThreadId = id;
            }
        }
    }

    @Override
    public JsonStreamHandler.JsonEntityHandler onEntityField(String fieldName) {
        return JsonStreamHandler.NULL_HANDLER;
    }

    @Override
    public void onObjectComplete() {
        this.onComplete();
        this.javaName = null;
        this.osThreadId = -1L;
        this.javaThreadId = -1L;
    }

    protected abstract void onComplete();
}

