/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.jvmtool.stacktrace.analytics.flame;

import java.awt.Color;
import org.gridkit.jvmtool.stacktrace.GenericStackElement;
import org.gridkit.jvmtool.stacktrace.StackFrame;
import org.gridkit.jvmtool.stacktrace.analytics.flame.FlameColorPicker;

public class DefaultColorPicker
implements FlameColorPicker {
    @Override
    public int pickColor(GenericStackElement[] trace) {
        if (trace.length == 0) {
            return 0xFFFFFF;
        }
        StackFrame sf = (StackFrame)trace[trace.length - 1];
        int c = DefaultColorPicker.hashColor(12, 10, sf);
        return c;
    }

    public static int hashColor(int baseHue, int deltaHue, StackFrame sf) {
        int hP = DefaultColorPicker.packageNameHash(sf.getClassName());
        int hC = DefaultColorPicker.classNameHash(sf.getClassName());
        int hM = sf.getMethodName().hashCode();
        int hue = deltaHue == 0 ? baseHue : baseHue + hP % (2 * deltaHue) - deltaHue;
        int sat = 180 + hC % 20 - 10;
        int lum = 220 + hM % 20 - 10;
        int c = Color.HSBtoRGB((float)hue / 255.0f, (float)sat / 255.0f, (float)lum / 255.0f);
        return c;
    }

    public static int hashGrayColor(StackFrame sf) {
        int hC = DefaultColorPicker.classNameHash(sf.getClassName());
        int hM = sf.getMethodName().hashCode();
        boolean hue = false;
        boolean sat = false;
        int lum = 220 + (hM + hC) % 20 - 10;
        int c = Color.HSBtoRGB((float)hue / 255.0f, (float)sat / 255.0f, (float)lum / 255.0f);
        return c;
    }

    private static int packageNameHash(String className) {
        int c = className.lastIndexOf(46);
        if (c >= 0) {
            return className.substring(0, c).hashCode();
        }
        return 0;
    }

    private static int classNameHash(String className) {
        int c = className.lastIndexOf(46);
        if (c >= 0) {
            className = className.substring(c + 1);
        }
        if ((c = className.indexOf(36)) >= 0) {
            int nhash = className.substring(0, c).hashCode();
            int shash = className.substring(c + 1).hashCode();
            return nhash + shash % 10;
        }
        return className.hashCode();
    }
}

