/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.jvmtool.stacktrace;

import java.lang.management.ThreadInfo;
import java.util.Arrays;
import java.util.Iterator;
import org.gridkit.jvmtool.stacktrace.CounterArray;
import org.gridkit.jvmtool.stacktrace.CounterCollection;
import org.gridkit.jvmtool.stacktrace.StackFrame;
import org.gridkit.jvmtool.stacktrace.StackFrameList;
import org.gridkit.jvmtool.stacktrace.ThreadSnapshot;

public class ThreadCapture
implements ThreadSnapshot {
    public long threadId;
    public String threadName;
    public long timestamp;
    public StackTraceElement[] elements;
    public CounterArray counters = new CounterArray();
    public Thread.State state;

    @Override
    public long threadId() {
        return this.threadId;
    }

    @Override
    public String threadName() {
        return this.threadName;
    }

    @Override
    public long timestamp() {
        return this.timestamp;
    }

    @Override
    public StackFrameList stackTrace() {
        return new StackProxy(this.elements);
    }

    @Override
    public Thread.State threadState() {
        return this.state;
    }

    @Override
    public CounterCollection counters() {
        return this.counters;
    }

    public void copyFrom(ThreadInfo info) {
        this.threadId = info.getThreadId();
        this.threadName = info.getThreadName();
        this.elements = info.getStackTrace();
        this.state = info.getThreadState();
        if (info.getBlockedCount() > 0L) {
            this.counters.set("java.blocked-count", info.getBlockedCount());
        }
        if (info.getBlockedTime() > 0L) {
            this.counters.set("java.blocked-time.ms", info.getBlockedTime());
        }
        if (info.getWaitedCount() > 0L) {
            this.counters.set("java.wait-count", info.getWaitedCount());
        }
        if (info.getWaitedTime() > 0L) {
            this.counters.set("java.wait-time.ms", info.getWaitedTime());
        }
    }

    public void reset() {
        this.threadId = -1L;
        this.threadName = null;
        this.timestamp = -1L;
        this.elements = null;
        this.counters.reset();
        this.state = null;
    }

    static class StackFrameWrapper
    extends StackFrame {
        StackTraceElement ste;

        public StackFrameWrapper(StackTraceElement ste) {
            super(ste);
            this.ste = ste;
        }

        @Override
        public StackTraceElement toStackTraceElement() {
            return this.ste;
        }
    }

    class StackProxy
    implements StackFrameList {
        StackTraceElement[] stack;

        public StackProxy(StackTraceElement[] stack) {
            this.stack = stack;
        }

        @Override
        public Iterator<StackFrame> iterator() {
            final Iterator<StackTraceElement> it = Arrays.asList(this.stack).iterator();
            return new Iterator<StackFrame>(){

                @Override
                public boolean hasNext() {
                    return it.hasNext();
                }

                @Override
                public StackFrame next() {
                    return new StackFrameWrapper((StackTraceElement)it.next());
                }

                @Override
                public void remove() {
                    it.remove();
                }
            };
        }

        @Override
        public StackFrame frameAt(int n) {
            return new StackFrameWrapper(this.stack[n]);
        }

        @Override
        public int depth() {
            return this.stack.length;
        }

        @Override
        public StackFrameList fragment(int from, int to) {
            throw new UnsupportedOperationException();
        }

        @Override
        public StackFrame[] toArray() {
            StackFrame[] frames = new StackFrame[this.stack.length];
            for (int i = 0; i != this.stack.length; ++i) {
                frames[i] = new StackFrameWrapper(this.stack[i]);
            }
            return frames;
        }

        @Override
        public boolean isEmpty() {
            return this.stack.length == 0;
        }
    }
}

