/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.jvmtool.stacktrace;

import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.gridkit.jvmtool.stacktrace.CounterCollection;

public class CounterArray
implements CounterCollection {
    public static CounterArray EMPTY = new CounterArray(new String[0], new long[0]){

        @Override
        public void set(String key, long value) {
            throw new UnsupportedOperationException("Immutable");
        }

        @Override
        public void reset() {
            throw new UnsupportedOperationException("Immutable");
        }
    };
    String[] counterNames;
    long[] values;

    public CounterArray() {
        this(new String[0], new long[0]);
    }

    public CounterArray(String[] names, long[] values) {
        if (names.length != values.length) {
            throw new IllegalArgumentException("Array length mismatch");
        }
        this.counterNames = names;
        this.values = values;
    }

    @Override
    public Iterator<String> iterator() {
        return new Iterator<String>(){
            int n = 0;
            {
                this.seek();
            }

            protected void seek() {
                while (this.n < CounterArray.this.counterNames.length && (CounterArray.this.counterNames[this.n] == null || CounterArray.this.values[this.n] == Long.MIN_VALUE)) {
                    ++this.n;
                }
            }

            @Override
            public boolean hasNext() {
                return this.n < CounterArray.this.counterNames.length;
            }

            @Override
            public String next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                String key = CounterArray.this.counterNames[this.n];
                ++this.n;
                this.seek();
                return key;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public long getValue(String key) {
        if (key == null) {
            throw new NullPointerException("key is null");
        }
        for (int i = 0; i != this.counterNames.length; ++i) {
            if (!key.equals(this.counterNames[i])) continue;
            return this.values[i];
        }
        return Long.MIN_VALUE;
    }

    @Override
    public CounterArray clone() {
        int n = 0;
        for (String key : this) {
            ++n;
        }
        String[] keys = new String[n];
        long[] vals = new long[n];
        n = 0;
        Iterator<String> i$ = this.iterator();
        while (i$.hasNext()) {
            String key;
            keys[n] = key = i$.next();
            vals[n] = this.getValue(key);
            ++n;
        }
        return new CounterArray(keys, vals);
    }

    public void copyFrom(CounterCollection cc) {
        this.reset();
        for (String key : cc) {
            this.set(key, cc.getValue(key));
        }
    }

    public void set(String key, long value) {
        if (key == null) {
            throw new NullPointerException("key is null");
        }
        for (int i = 0; i != this.counterNames.length; ++i) {
            if (!key.equals(this.counterNames[i])) continue;
            this.values[i] = value;
            return;
        }
        if (value != Long.MIN_VALUE) {
            int n = this.counterNames.length;
            this.counterNames = Arrays.copyOf(this.counterNames, n + 1);
            this.values = Arrays.copyOf(this.values, n + 1);
            this.counterNames[n] = key;
            this.values[n] = value;
        }
    }

    public void reset() {
        Arrays.fill(this.values, Long.MIN_VALUE);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        for (String key : this) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append(key).append(": ").append(this.getValue(key));
        }
        sb.append(']');
        return sb.toString();
    }
}

