/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.yamlinput;

import java.util.List;
import org.apache.commons.vfs2.FileObject;
import org.apache.hop.core.Const;
import org.apache.hop.core.ResultFile;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.fileinput.FileInputList;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.RowDataUtil;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.row.value.ValueMetaFactory;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.yamlinput.YamlInputData;
import org.apache.hop.pipeline.transforms.yamlinput.YamlInputField;
import org.apache.hop.pipeline.transforms.yamlinput.YamlInputMeta;
import org.apache.hop.pipeline.transforms.yamlinput.YamlReader;

public class YamlInput
extends BaseTransform<YamlInputMeta, YamlInputData> {
    private static final Class<?> PKG = YamlInputMeta.class;

    public YamlInput(TransformMeta transformMeta, YamlInputMeta meta, YamlInputData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    private void handleMissingFiles() throws HopException {
        List nonExistantFiles = ((YamlInputData)this.data).files.getNonExistentFiles();
        if (!nonExistantFiles.isEmpty()) {
            String message = FileInputList.getRequiredFilesDescription((List)nonExistantFiles);
            this.logError(BaseMessages.getString(PKG, (String)"YamlInput.Log.RequiredFilesTitle", (String[])new String[0]), new Object[]{BaseMessages.getString(PKG, (String)"YamlInput.Log.RequiredFiles", (String[])new String[]{message})});
            throw new HopException(BaseMessages.getString(PKG, (String)"YamlInput.Log.RequiredFilesMissing", (String[])new String[]{message}));
        }
        List nonAccessibleFiles = ((YamlInputData)this.data).files.getNonAccessibleFiles();
        if (!nonAccessibleFiles.isEmpty()) {
            String message = FileInputList.getRequiredFilesDescription((List)nonAccessibleFiles);
            this.logError(BaseMessages.getString(PKG, (String)"YamlInput.Log.RequiredFilesTitle", (String[])new String[0]), new Object[]{BaseMessages.getString(PKG, (String)"YamlInput.Log.RequiredNotAccessibleFiles", (String[])new String[]{message})});
            throw new HopException(BaseMessages.getString(PKG, (String)"YamlInput.Log.RequiredNotAccessibleFilesMissing", (String[])new String[]{message}));
        }
    }

    private boolean readNextString() {
        try {
            ((YamlInputData)this.data).readrow = this.getRow();
            if (((YamlInputData)this.data).readrow == null) {
                if (this.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"YamlInput.Log.FinishedProcessing", (String[])new String[0]));
                }
                return false;
            }
            if (this.first) {
                this.first = false;
                ((YamlInputData)this.data).outputRowMeta = this.getInputRowMeta().clone();
                ((YamlInputData)this.data).totalPreviousFields = ((YamlInputData)this.data).outputRowMeta.size();
                ((YamlInputData)this.data).totalOutFields = ((YamlInputData)this.data).totalPreviousFields + ((YamlInputData)this.data).nrInputFields;
                ((YamlInputMeta)this.meta).getFields(((YamlInputData)this.data).outputRowMeta, this.getTransformName(), null, null, (IVariables)this, this.metadataProvider);
                if (Utils.isEmpty((CharSequence)((YamlInputMeta)this.meta).getYamlField())) {
                    this.logError(BaseMessages.getString(PKG, (String)"YamlInput.Log.NoField", (String[])new String[0]));
                    throw new HopException(BaseMessages.getString(PKG, (String)"YamlInput.Log.NoField", (String[])new String[0]));
                }
                ((YamlInputData)this.data).indexOfYamlField = this.getInputRowMeta().indexOfValue(((YamlInputMeta)this.meta).getYamlField());
                if (((YamlInputData)this.data).indexOfYamlField < 0) {
                    this.logError(BaseMessages.getString(PKG, (String)"YamlInput.Log.ErrorFindingField", (String[])new String[]{((YamlInputMeta)this.meta).getYamlField()}));
                    throw new HopException(BaseMessages.getString(PKG, (String)"YamlInput.Exception.CouldnotFindField", (String[])new String[]{((YamlInputMeta)this.meta).getYamlField()}));
                }
            }
            String fieldvalue = this.getInputRowMeta().getString(((YamlInputData)this.data).readrow, ((YamlInputData)this.data).indexOfYamlField);
            this.getLinesInput();
            if (this.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"YamlInput.Log.YAMLStream", (String[])new String[]{((YamlInputMeta)this.meta).getYamlField(), fieldvalue}));
            }
            if (((YamlInputMeta)this.meta).getIsAFile()) {
                ((YamlInputData)this.data).yaml = new YamlReader();
                ((YamlInputData)this.data).yaml.loadFile(HopVfs.getFileObject((String)fieldvalue, (IVariables)this.variables));
                this.addFileToResultFilesname(((YamlInputData)this.data).yaml.getFile());
            } else {
                ((YamlInputData)this.data).yaml = new YamlReader();
                ((YamlInputData)this.data).yaml.loadString(fieldvalue);
            }
        }
        catch (Exception e) {
            this.logError(BaseMessages.getString(PKG, (String)"YamlInput.Log.UnexpectedError", (String[])new String[]{e.toString()}));
            this.stopAll();
            this.logError(Const.getStackTracker((Throwable)e));
            this.setErrors(1L);
            return false;
        }
        return true;
    }

    private void addFileToResultFilesname(FileObject file) {
        if (((YamlInputMeta)this.meta).addResultFile()) {
            ResultFile resultFile = new ResultFile(0, file, this.getPipelineMeta().getName(), this.getTransformName());
            resultFile.setComment(BaseMessages.getString(PKG, (String)"YamlInput.Log.FileAddedResult", (String[])new String[0]));
            this.addResultFile(resultFile);
        }
    }

    private boolean openNextFile() {
        try {
            if (((YamlInputData)this.data).filenr >= ((YamlInputData)this.data).files.nrOfFiles()) {
                if (this.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"YamlInput.Log.FinishedProcessing", (String[])new String[0]));
                }
                return false;
            }
            ((YamlInputData)this.data).file = ((YamlInputData)this.data).files.getFile(((YamlInputData)this.data).filenr);
            ++((YamlInputData)this.data).filenr;
            if (((YamlInputMeta)this.meta).isIgnoreEmptyFile() && ((YamlInputData)this.data).file.getContent().getSize() == 0L) {
                if (this.isBasic()) {
                    this.logBasic(BaseMessages.getString(PKG, (String)"YamlInput.Error.FileSizeZero", (Object[])new Object[]{((YamlInputData)this.data).file.getName()}));
                }
                this.openNextFile();
            } else {
                if (this.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"YamlInput.Log.OpeningFile", (String[])new String[]{((YamlInputData)this.data).file.toString()}));
                }
                ((YamlInputData)this.data).yaml = new YamlReader();
                ((YamlInputData)this.data).yaml.loadFile(((YamlInputData)this.data).file);
                this.addFileToResultFilesname(((YamlInputData)this.data).file);
                if (this.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"YamlInput.Log.FileOpened", (String[])new String[]{((YamlInputData)this.data).file.toString()}));
                }
            }
        }
        catch (Exception e) {
            this.logError(BaseMessages.getString(PKG, (String)"YamlInput.Log.UnableToOpenFile", (String[])new String[]{"" + ((YamlInputData)this.data).filenr, ((YamlInputData)this.data).file.toString(), e.toString()}));
            this.stopAll();
            this.setErrors(1L);
            this.logError(Const.getStackTracker((Throwable)e));
            return false;
        }
        return true;
    }

    public boolean processRow() throws HopException {
        Object[] r;
        if (this.first && !((YamlInputMeta)this.meta).isInFields()) {
            this.first = false;
            ((YamlInputData)this.data).files = ((YamlInputMeta)this.meta).getFiles((IVariables)this);
            if (!((YamlInputMeta)this.meta).isdoNotFailIfNoFile() && ((YamlInputData)this.data).files.nrOfFiles() == 0) {
                throw new HopException(BaseMessages.getString(PKG, (String)"YamlInput.Log.NoFiles", (String[])new String[0]));
            }
            this.handleMissingFiles();
            ((YamlInputData)this.data).outputRowMeta = new RowMeta();
            ((YamlInputData)this.data).totalPreviousFields = 0;
            ((YamlInputData)this.data).totalOutFields = ((YamlInputData)this.data).totalPreviousFields + ((YamlInputData)this.data).nrInputFields;
            ((YamlInputMeta)this.meta).getFields(((YamlInputData)this.data).outputRowMeta, this.getTransformName(), null, null, (IVariables)this, this.metadataProvider);
            ((YamlInputData)this.data).totalOutStreamFields = ((YamlInputData)this.data).outputRowMeta.size();
        }
        if ((r = this.getOneRow()) == null) {
            this.setOutputDone();
            return false;
        }
        if (this.isRowLevel()) {
            this.logRowlevel(BaseMessages.getString(PKG, (String)"YamlInput.Log.ReadRow", (String[])new String[]{((YamlInputData)this.data).outputRowMeta.getString(r)}));
        }
        this.incrementLinesOutput();
        ++((YamlInputData)this.data).rownr;
        Object[] rowCopy = ((YamlInputData)this.data).outputRowMeta.cloneRow(r);
        this.putRow(((YamlInputData)this.data).outputRowMeta, rowCopy);
        if (((YamlInputMeta)this.meta).getRowLimit() > 0L && ((YamlInputData)this.data).rownr > ((YamlInputMeta)this.meta).getRowLimit()) {
            this.setOutputDone();
            return false;
        }
        return true;
    }

    private Object[] getOneRow() throws HopException {
        Object[] row = null;
        boolean rowAvailable = false;
        boolean fileOpened = false;
        if (!((YamlInputMeta)this.meta).isInFields()) {
            while (((YamlInputData)this.data).file == null || ((YamlInputData)this.data).file != null && !fileOpened && !rowAvailable) {
                if (((YamlInputData)this.data).file != null) {
                    row = this.getRowData();
                    if (row == null) {
                        if (!this.openNextFile()) {
                            return null;
                        }
                        fileOpened = true;
                        continue;
                    }
                    rowAvailable = true;
                    continue;
                }
                if (!this.openNextFile()) {
                    return null;
                }
                fileOpened = true;
            }
        } else {
            while (((YamlInputData)this.data).readrow == null || ((YamlInputData)this.data).readrow != null && !fileOpened && !rowAvailable) {
                if (((YamlInputData)this.data).readrow != null) {
                    row = this.getRowData();
                    if (row == null) {
                        if (!this.readNextString()) {
                            return null;
                        }
                        fileOpened = true;
                    } else {
                        rowAvailable = true;
                    }
                } else {
                    if (!this.readNextString()) {
                        return null;
                    }
                    fileOpened = true;
                }
                if (((YamlInputData)this.data).readrow != null) continue;
                return null;
            }
        }
        if (!rowAvailable) {
            row = this.getRowData();
        }
        return row;
    }

    private Object[] getRowData() throws HopException {
        Object[] outputRowData;
        block7: {
            outputRowData = null;
            try {
                outputRowData = ((YamlInputData)this.data).yaml.getRow(((YamlInputData)this.data).rowMeta);
                if (outputRowData == null) {
                    return null;
                }
                outputRowData = ((YamlInputData)this.data).readrow != null ? RowDataUtil.addRowData((Object[])((YamlInputData)this.data).readrow, (int)((YamlInputData)this.data).totalPreviousFields, (Object[])outputRowData) : RowDataUtil.resizeArray((Object[])outputRowData, (int)((YamlInputData)this.data).totalOutStreamFields);
                int rowIndex = ((YamlInputData)this.data).totalOutFields;
                if (((YamlInputMeta)this.meta).includeFilename() && !Utils.isEmpty((CharSequence)((YamlInputMeta)this.meta).getFilenameField())) {
                    outputRowData[rowIndex++] = HopVfs.getFilename((FileObject)((YamlInputData)this.data).file);
                }
                if (((YamlInputMeta)this.meta).includeRowNumber() && !Utils.isEmpty((CharSequence)((YamlInputMeta)this.meta).getRowNumberField())) {
                    outputRowData[rowIndex++] = ((YamlInputData)this.data).rownr;
                }
            }
            catch (Exception e) {
                boolean sendToErrorRow = false;
                String errorMessage = null;
                if (this.getTransformMeta().isDoingErrorHandling()) {
                    sendToErrorRow = true;
                    errorMessage = e.toString();
                } else {
                    this.logError(BaseMessages.getString(PKG, (String)"YamlInput.ErrorInTransformRunning", (String[])new String[]{e.toString()}));
                    this.setErrors(1L);
                    this.stopAll();
                    this.logError(Const.getStackTracker((Throwable)e));
                    this.setOutputDone();
                }
                if (!sendToErrorRow) break block7;
                this.putError(this.getInputRowMeta(), outputRowData, 1L, errorMessage, null, "YamlInput001");
            }
        }
        return outputRowData;
    }

    public boolean init() {
        if (super.init()) {
            ((YamlInputData)this.data).rownr = 1L;
            ((YamlInputData)this.data).nrInputFields = ((YamlInputMeta)this.meta).getInputFields().length;
            ((YamlInputData)this.data).rowMeta = new RowMeta();
            for (int i = 0; i < ((YamlInputData)this.data).nrInputFields; ++i) {
                YamlInputField field = ((YamlInputMeta)this.meta).getInputFields()[i];
                String path = this.resolve(field.getPath());
                try {
                    IValueMeta valueMeta = ValueMetaFactory.createValueMeta((String)path, (int)field.getType());
                    valueMeta.setTrimType(field.getTrimType());
                    ((YamlInputData)this.data).rowMeta.addValueMeta(valueMeta);
                    continue;
                }
                catch (Exception e) {
                    this.logError("Unable to create value meta", e);
                    return false;
                }
            }
            return true;
        }
        return false;
    }
}

