/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.UserFunctionCall;
import net.sf.saxon.functions.FunctionLibrary;
import net.sf.saxon.style.XSLFunction;
import net.sf.saxon.style.XSLStylesheet;
import net.sf.saxon.trans.XPathException;

public class StylesheetFunctionLibrary
implements FunctionLibrary {
    private XSLStylesheet stylesheet;
    private boolean overriding;

    public StylesheetFunctionLibrary(XSLStylesheet xSLStylesheet, boolean bl) {
        this.stylesheet = xSLStylesheet;
        this.overriding = bl;
    }

    public boolean isAvailable(int n, String string, String string2, int n2) {
        XSLFunction xSLFunction = this.stylesheet.getStylesheetFunction(n, n2);
        return xSLFunction != null;
    }

    public Expression bind(int n, String string, String string2, Expression[] expressionArray) throws XPathException {
        int n2 = n & 0xFFFFF;
        XSLFunction xSLFunction = this.stylesheet.getStylesheetFunction(n2, expressionArray.length);
        if (xSLFunction == null) {
            return null;
        }
        if (xSLFunction.isOverriding() != this.overriding) {
            return null;
        }
        UserFunctionCall userFunctionCall = new UserFunctionCall();
        xSLFunction.registerReference(userFunctionCall);
        userFunctionCall.setFunctionNameCode(n);
        userFunctionCall.setArguments(expressionArray);
        userFunctionCall.setConfirmed(true);
        return userFunctionCall;
    }

    public FunctionLibrary copy() {
        return this;
    }
}

