/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import java.io.PrintStream;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.Err;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.FunctionCall;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.instruct.DummyNamespaceResolver;
import net.sf.saxon.instruct.InstructionDetails;
import net.sf.saxon.instruct.SimpleNodeConstructor;
import net.sf.saxon.instruct.TailCall;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.Orphan;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.trace.InstructionInfo;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.StaticError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyType;
import net.sf.saxon.type.ComplexType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.StringValue;

public final class FixedAttribute
extends SimpleNodeConstructor {
    private int nameCode;
    private SimpleType schemaType;
    private int annotation;
    private int options;
    private int validationAction;

    public FixedAttribute(int n, int n2, SimpleType simpleType, int n3) {
        this.nameCode = n;
        this.schemaType = simpleType;
        this.annotation = n3 == -1 ? 642 : n3;
        this.validationAction = n2;
        this.options = 0;
    }

    public int getInstructionNameCode() {
        return 131;
    }

    public void setRejectDuplicates() {
        this.options |= 0x20;
    }

    public void setNoSpecialChars() {
        this.options |= 4;
    }

    public void setSelect(Expression object, Configuration configuration) throws StaticError {
        Expression[] expressionArray;
        Object object2;
        super.setSelect((Expression)object, configuration);
        if (object instanceof AtomicValue && this.schemaType != null && !this.schemaType.isNamespaceSensitive() && (object2 = this.schemaType.validateContent((CharSequence)(expressionArray = ((AtomicValue)object).getStringValueCS()), DummyNamespaceResolver.getInstance(), configuration.getNameChecker())) != null) {
            throw new StaticError("Attribute value " + Err.wrap((CharSequence)expressionArray, 4) + " does not the match the required type " + this.schemaType.getDescription() + ". " + ((Throwable)object2).getMessage());
        }
        if (object instanceof StringValue) {
            boolean bl = false;
            object2 = ((StringValue)object).getStringValueCS();
            for (int i = 0; i < object2.length(); ++i) {
                char c = object2.charAt(i);
                if (c >= '!' && c <= '~' && c != '<' && c != '>' && c != '&' && c != '\"') continue;
                bl = true;
                break;
            }
            if (!bl) {
                this.options |= 4;
            }
        }
        if ((this.nameCode & 0xFFFFF) == 388) {
            expressionArray = new Expression[]{object};
            object2 = SystemFunction.makeSystemFunction("normalize-space", 1, configuration.getNamePool());
            ((FunctionCall)object2).setArguments(expressionArray);
            object = object2;
            super.setSelect((Expression)object, configuration);
        }
    }

    public InstructionInfo getInstructionInfo() {
        InstructionDetails instructionDetails = (InstructionDetails)super.getInstructionInfo();
        instructionDetails.setConstructType(2007);
        instructionDetails.setObjectNameCode(this.nameCode);
        return instructionDetails;
    }

    public ItemType getItemType(TypeHierarchy typeHierarchy) {
        return NodeKindTest.ATTRIBUTE;
    }

    public int getCardinality() {
        return 16384;
    }

    public void localTypeCheck(StaticContext staticContext, ItemType itemType) {
    }

    protected int evaluateNameCode(XPathContext xPathContext) {
        return this.nameCode;
    }

    public void checkPermittedContents(SchemaType schemaType, StaticContext staticContext, boolean bl) throws XPathException {
        SchemaType schemaType2;
        int n = this.nameCode & 0xFFFFF;
        if (n == 769 || n == 771 || n == 770 || n == 772) {
            return;
        }
        if (schemaType instanceof SimpleType) {
            StaticError staticError = new StaticError("Attribute " + staticContext.getNamePool().getDisplayName(this.nameCode) + " is not permitted in the content model of the simple type " + schemaType.getDescription());
            staticError.setIsTypeError(true);
            staticError.setLocator(this);
            throw staticError;
        }
        try {
            schemaType2 = ((ComplexType)schemaType).getAttributeUseType(n);
        }
        catch (SchemaException schemaException) {
            throw new StaticError(schemaException);
        }
        if (schemaType2 == null) {
            StaticError staticError = new StaticError("Attribute " + staticContext.getNamePool().getDisplayName(this.nameCode) + " is not permitted in the content model of the complex type " + schemaType.getDescription());
            staticError.setIsTypeError(true);
            staticError.setLocator(this);
            throw staticError;
        }
        if (schemaType2 instanceof AnyType) {
            return;
        }
        try {
            this.select.checkPermittedContents(schemaType2, staticContext, true);
        }
        catch (XPathException xPathException) {
            if (xPathException.getLocator() == null || xPathException.getLocator() == xPathException) {
                xPathException.setLocator(this);
            }
            throw xPathException;
        }
    }

    public TailCall processLeavingTail(XPathContext xPathContext) throws XPathException {
        Controller controller = xPathContext.getController();
        SequenceReceiver sequenceReceiver = xPathContext.getReceiver();
        int n = this.options;
        int n2 = this.annotation;
        String string = ((Object)this.expandChildren(xPathContext)).toString();
        if (this.schemaType != null) {
            ValidationException validationException = this.schemaType.validateContent(string, DummyNamespaceResolver.getInstance(), xPathContext.getConfiguration().getNameChecker());
            if (validationException != null) {
                ValidationException validationException2 = new ValidationException("Attribute value " + Err.wrap(string, 4) + " does not the match the required type " + this.schemaType.getDescription() + ". " + validationException.getMessage());
                validationException2.setLocator(this);
                throw validationException2;
            }
        } else if (this.validationAction == 1 || this.validationAction == 2) {
            try {
                n2 = controller.getConfiguration().validateAttribute(this.nameCode, string, this.validationAction);
            }
            catch (ValidationException validationException) {
                DynamicError dynamicError = DynamicError.makeDynamicError(validationException);
                dynamicError.setErrorCode(validationException.getErrorCodeLocalPart());
                dynamicError.setXPathContext(xPathContext);
                dynamicError.setLocator(this);
                dynamicError.setIsTypeError(true);
                throw dynamicError;
            }
        }
        try {
            sequenceReceiver.attribute(this.nameCode, n2, string, this.locationId, n);
        }
        catch (XPathException xPathException) {
            throw FixedAttribute.dynamicError(this, xPathException, xPathContext);
        }
        return null;
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        Orphan orphan = (Orphan)super.evaluateItem(xPathContext);
        if (this.schemaType != null) {
            ValidationException validationException = this.schemaType.validateContent(orphan.getStringValueCS(), DummyNamespaceResolver.getInstance(), xPathContext.getConfiguration().getNameChecker());
            if (validationException != null) {
                throw new ValidationException("Attribute value " + Err.wrap(orphan.getStringValueCS(), 4) + " does not the match the required type " + this.schemaType.getDescription() + ". " + validationException.getMessage());
            }
            orphan.setTypeAnnotation(this.schemaType.getFingerprint());
            if (this.schemaType.isNamespaceSensitive()) {
                throw new DynamicError("Cannot validate a parentless attribute whose content is namespace-sensitive");
            }
        } else if (this.validationAction == 1 || this.validationAction == 2) {
            try {
                int n = xPathContext.getController().getConfiguration().validateAttribute(this.nameCode, orphan.getStringValueCS(), this.validationAction);
                orphan.setTypeAnnotation(n);
            }
            catch (ValidationException validationException) {
                DynamicError dynamicError = DynamicError.makeDynamicError(validationException);
                dynamicError.setErrorCode(validationException.getErrorCodeLocalPart());
                dynamicError.setXPathContext(xPathContext);
                dynamicError.setLocator(this);
                dynamicError.setIsTypeError(true);
                throw dynamicError;
            }
        }
        return orphan;
    }

    public void display(int n, NamePool namePool, PrintStream printStream) {
        printStream.println(ExpressionTool.indent(n) + "attribute ");
        printStream.println(ExpressionTool.indent(n + 1) + "name " + (namePool == null ? this.nameCode + "" : namePool.getDisplayName(this.nameCode)));
        super.display(n + 1, namePool, printStream);
    }
}

