/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.sigar.test;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import junit.framework.TestCase;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;
import org.hyperic.sigar.SigarProxy;
import org.hyperic.sigar.SigarProxyCache;
import org.hyperic.sigar.test.Proxy;

public class TestThreads
extends TestCase {
    private static Sigar gSigar = null;
    private static SigarProxy gProxy = null;
    private static Object lock = new Object();
    private static boolean verbose = true;

    public TestThreads(String name) {
        super(name);
    }

    public void testCreate() throws Exception {
        ProxyThread pt;
        ArrayList<ProxyThread> threads = new ArrayList<ProxyThread>();
        for (int i = 0; i < 4; ++i) {
            pt = new ProxyThread();
            pt.useGlobal = true;
            threads.add(pt);
            pt.start();
        }
        for (int n = 0; n < threads.size(); ++n) {
            pt = (ProxyThread)threads.get(n);
            pt.join();
            if (pt.ex == null) continue;
            pt.ex.printStackTrace();
            TestThreads.fail((String)pt.ex.getMessage());
        }
    }

    class ProxyThread
    extends Thread {
        SigarException ex;
        boolean useGlobal = false;

        ProxyThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                SigarProxy proxy;
                Sigar sigar;
                Object object = lock;
                synchronized (object) {
                    if (this.useGlobal) {
                        if (gSigar == null) {
                            gSigar = new Sigar();
                            gProxy = SigarProxyCache.newInstance(gSigar, 30000);
                        }
                        sigar = gSigar;
                        proxy = gProxy;
                    } else {
                        sigar = new Sigar();
                        proxy = SigarProxyCache.newInstance(sigar, 30000);
                    }
                }
                String[] args = new String[]{"leaktest", "50"};
                Proxy cmdProxy = new Proxy(sigar, proxy);
                PrintStream ps = new PrintStream(new ByteArrayOutputStream());
                if (verbose) {
                    cmdProxy.setVerbose(true);
                    cmdProxy.setLeakVerbose(true);
                    cmdProxy.run(args);
                } else {
                    cmdProxy.setOutputStream(ps);
                }
            }
            catch (SigarException e) {
                this.ex = e;
            }
        }
    }
}

