/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.parquet.transforms.output;

import org.apache.hop.metadata.api.IEnumHasCode;

public enum ParquetVersion implements IEnumHasCode
{
    Version1("1.0", "Parquet 1.0"),
    Version2("2.0", "Parquet 2.0");

    private String code;
    private String description;

    private ParquetVersion(String code, String description) {
        this.code = code;
        this.description = description;
    }

    public static final String[] getDescriptions() {
        String[] descriptions = new String[ParquetVersion.values().length];
        for (int i = 0; i < descriptions.length; ++i) {
            descriptions[i] = ParquetVersion.values()[i].description;
        }
        return descriptions;
    }

    public static ParquetVersion getVersionFromDescription(String description) {
        for (ParquetVersion version : ParquetVersion.values()) {
            if (!version.getDescription().equals(description)) continue;
            return version;
        }
        return Version1;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }
}

