/*
 * Decompiled with CFR 0.152.
 */
package org.tukaani.xz;

import java.io.IOException;
import java.io.InputStream;
import org.tukaani.xz.XZIOException;
import org.tukaani.xz.delta.DeltaDecoder;

public class DeltaInputStream
extends InputStream {
    public static final int DISTANCE_MIN = 1;
    public static final int DISTANCE_MAX = 256;
    private InputStream in;
    private final DeltaDecoder delta;
    private IOException exception = null;
    private final byte[] tempBuf = new byte[1];

    public DeltaInputStream(InputStream inputStream, int n) {
        if (inputStream == null) {
            throw new NullPointerException();
        }
        this.in = inputStream;
        this.delta = new DeltaDecoder(n);
    }

    @Override
    public int read() throws IOException {
        return this.read(this.tempBuf, 0, 1) == -1 ? -1 : this.tempBuf[0] & 0xFF;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        if (n2 == 0) {
            return 0;
        }
        if (this.in == null) {
            throw new XZIOException("Stream closed");
        }
        if (this.exception != null) {
            throw this.exception;
        }
        try {
            n3 = this.in.read(byArray, n, n2);
        }
        catch (IOException iOException) {
            this.exception = iOException;
            throw iOException;
        }
        if (n3 == -1) {
            return -1;
        }
        this.delta.decode(byArray, n, n3);
        return n3;
    }

    @Override
    public int available() throws IOException {
        if (this.in == null) {
            throw new XZIOException("Stream closed");
        }
        if (this.exception != null) {
            throw this.exception;
        }
        return this.in.available();
    }

    @Override
    public void close() throws IOException {
        if (this.in != null) {
            try {
                this.in.close();
            }
            finally {
                this.in = null;
            }
        }
    }
}

