/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.uniquerows;

import java.util.ArrayList;
import java.util.List;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaInteger;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.uniquerows.UniqueField;
import org.apache.hop.pipeline.transforms.uniquerows.UniqueRows;
import org.apache.hop.pipeline.transforms.uniquerows.UniqueRowsData;

@Transform(id="Unique", image="uniquerows.svg", name="i18n::UniqueRows.Name", description="i18n::UniqueRows.Description", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Transform", keywords={"i18n::UniqueRowsMeta.keyword"}, documentationUrl="/pipeline/transforms/uniquerows.html")
public class UniqueRowsMeta
extends BaseTransformMeta<UniqueRows, UniqueRowsData> {
    private static final Class<?> PKG = UniqueRowsMeta.class;
    @HopMetadataProperty(key="count_rows", injectionKeyDescription="UniqueRowsMeta.Injection.CountRows")
    private boolean countRows;
    @HopMetadataProperty(key="count_field", injectionKeyDescription="UniqueRowsMeta.Injection.CountField")
    private String countField;
    @HopMetadataProperty(groupKey="fields", key="field", injectionGroupDescription="UniqueRowsMeta.Injection.Fields", injectionKeyDescription="UniqueRowsMeta.Injection.Field")
    private List<UniqueField> compareFields;
    @HopMetadataProperty(key="reject_duplicate_row", injectionKeyDescription="UniqueRowsMeta.Injection.RejectDuplicateRow")
    private boolean rejectDuplicateRow;
    @HopMetadataProperty(key="error_description", injectionKeyDescription="UniqueRowsMeta.Injection.ErrorDescription")
    private String errorDescription;

    public UniqueRowsMeta() {
        this.compareFields = new ArrayList<UniqueField>();
    }

    public UniqueRowsMeta(UniqueRowsMeta meta) {
        this.countRows = meta.countRows;
        this.countField = meta.countField;
        this.errorDescription = meta.errorDescription;
        this.rejectDuplicateRow = meta.rejectDuplicateRow;
        this.compareFields = new ArrayList<UniqueField>();
        for (UniqueField field : meta.getCompareFields()) {
            this.compareFields.add(new UniqueField(field.getName(), field.isCaseInsensitive()));
        }
    }

    public boolean isCountRows() {
        return this.countRows;
    }

    public void setCountRows(boolean countRows) {
        this.countRows = countRows;
    }

    public String getCountField() {
        return this.countField;
    }

    public void setCountField(String countField) {
        this.countField = countField;
    }

    public void setCompareFields(List<UniqueField> compareField) {
        this.compareFields = compareField;
    }

    public List<UniqueField> getCompareFields() {
        return this.compareFields;
    }

    public void setRejectDuplicateRow(boolean rejectDuplicateRow) {
        this.rejectDuplicateRow = rejectDuplicateRow;
    }

    public boolean isRejectDuplicateRow() {
        return this.rejectDuplicateRow;
    }

    public String getErrorDescription() {
        return this.errorDescription;
    }

    public void setErrorDescription(String errorDescription) {
        this.errorDescription = errorDescription;
    }

    public Object clone() {
        return new UniqueRowsMeta(this);
    }

    public void setDefault() {
        this.countRows = false;
        this.countField = "";
        this.rejectDuplicateRow = false;
        this.errorDescription = null;
        this.compareFields = new ArrayList<UniqueField>();
    }

    public void getFields(IRowMeta row, String name, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
        for (UniqueField field : this.compareFields) {
            int idx = row.indexOfValue(field.getName());
            if (idx < 0) continue;
            row.getValueMeta(idx).setCaseInsensitive(field.isCaseInsensitive());
        }
        if (this.countRows) {
            ValueMetaInteger v = new ValueMetaInteger(this.countField);
            v.setLength(10, 0);
            v.setOrigin(name);
            row.addValueMeta((IValueMeta)v);
        }
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        if (input.length > 0) {
            CheckResult cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"UniqueRowsMeta.CheckResult.TransformReceivingInfoFromOtherTransforms", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            CheckResult cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"UniqueRowsMeta.CheckResult.NoInputReceivedFromOtherTransforms", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
    }

    public boolean supportsErrorHandling() {
        return this.isRejectDuplicateRow();
    }
}

