/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.shaded.zookeeper3.org.apache.jute.compiler;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.flink.shaded.zookeeper3.org.apache.jute.compiler.CGenerator;
import org.apache.flink.shaded.zookeeper3.org.apache.jute.compiler.CSharpGenerator;
import org.apache.flink.shaded.zookeeper3.org.apache.jute.compiler.CppGenerator;
import org.apache.flink.shaded.zookeeper3.org.apache.jute.compiler.JRecord;
import org.apache.flink.shaded.zookeeper3.org.apache.jute.compiler.JavaGenerator;

public class JFile {
    private String mName;
    private List<JFile> mInclFiles;
    private List<JRecord> mRecords;

    public JFile(String name, ArrayList<JFile> inclFiles, ArrayList<JRecord> recList) {
        this.mName = name;
        this.mInclFiles = inclFiles;
        this.mRecords = recList;
    }

    String getName() {
        int idx = this.mName.lastIndexOf(47);
        return idx > 0 ? this.mName.substring(idx) : this.mName;
    }

    public void genCode(String language, File outputDirectory) throws IOException {
        if ("c++".equals(language)) {
            CppGenerator gen = new CppGenerator(this.mName, this.mInclFiles, this.mRecords, outputDirectory);
            gen.genCode();
        } else if ("java".equals(language)) {
            JavaGenerator gen = new JavaGenerator(this.mName, this.mInclFiles, this.mRecords, outputDirectory);
            gen.genCode();
        } else if ("c".equals(language)) {
            CGenerator gen = new CGenerator(this.mName, this.mInclFiles, this.mRecords, outputDirectory);
            gen.genCode();
        } else if ("csharp".equals(language)) {
            CSharpGenerator gen = new CSharpGenerator(this.mName, this.mInclFiles, this.mRecords, outputDirectory);
            gen.genCode();
        } else {
            throw new IOException("Cannnot recognize language:" + language);
        }
    }
}

