/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesis.leases.impl;

import com.amazonaws.services.kinesis.clientlibrary.lib.worker.ShardInfo;
import com.amazonaws.services.kinesis.clientlibrary.proxies.IKinesisProxy;
import com.amazonaws.services.kinesis.clientlibrary.types.ExtendedSequenceNumber;
import com.amazonaws.services.kinesis.leases.LeasePendingDeletion;
import com.amazonaws.services.kinesis.leases.exceptions.DependencyException;
import com.amazonaws.services.kinesis.leases.exceptions.InvalidStateException;
import com.amazonaws.services.kinesis.leases.exceptions.ProvisionedThroughputException;
import com.amazonaws.services.kinesis.leases.impl.KinesisClientLease;
import com.amazonaws.services.kinesis.leases.impl.UpdateField;
import com.amazonaws.services.kinesis.leases.interfaces.ILeaseManager;
import com.amazonaws.services.kinesis.metrics.interfaces.IMetricsFactory;
import com.amazonaws.services.kinesis.model.ResourceNotFoundException;
import com.amazonaws.services.kinesis.model.ShardIteratorType;
import com.amazonaws.util.CollectionUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Stopwatch;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LeaseCleanupManager {
    @NonNull
    private IKinesisProxy kinesisProxy;
    @NonNull
    private final ILeaseManager<KinesisClientLease> leaseManager;
    @NonNull
    private final ScheduledExecutorService deletionThreadPool;
    @NonNull
    private final IMetricsFactory metricsFactory;
    private final boolean cleanupLeasesUponShardCompletion;
    private final long leaseCleanupIntervalMillis;
    private final long completedLeaseCleanupIntervalMillis;
    private final long garbageLeaseCleanupIntervalMillis;
    private final int maxRecords;
    private final Stopwatch completedLeaseStopwatch = Stopwatch.createUnstarted();
    private final Stopwatch garbageLeaseStopwatch = Stopwatch.createUnstarted();
    private final Queue<LeasePendingDeletion> deletionQueue = new ConcurrentLinkedQueue<LeasePendingDeletion>();
    private static final long INITIAL_DELAY = 0L;
    private static final Log LOG = LogFactory.getLog(LeaseCleanupManager.class);
    private volatile boolean isRunning = false;

    public static LeaseCleanupManager newInstance(IKinesisProxy kinesisProxy, ILeaseManager leaseManager, ScheduledExecutorService deletionThreadPool, IMetricsFactory metricsFactory, boolean cleanupLeasesUponShardCompletion, long leaseCleanupIntervalMillis, long completedLeaseCleanupIntervalMillis, long garbageLeaseCleanupIntervalMillis, int maxRecords) {
        return new LeaseCleanupManager(kinesisProxy, leaseManager, deletionThreadPool, metricsFactory, cleanupLeasesUponShardCompletion, leaseCleanupIntervalMillis, completedLeaseCleanupIntervalMillis, garbageLeaseCleanupIntervalMillis, maxRecords);
    }

    public void start() {
        if (!this.isRunning) {
            LOG.info((Object)"Starting lease cleanup thread.");
            this.completedLeaseStopwatch.start();
            this.garbageLeaseStopwatch.start();
            this.deletionThreadPool.scheduleAtFixedRate(new LeaseCleanupThread(), 0L, this.leaseCleanupIntervalMillis, TimeUnit.MILLISECONDS);
            this.isRunning = true;
        } else {
            LOG.info((Object)"Lease cleanup thread already running, no need to start.");
        }
    }

    public void enqueueForDeletion(LeasePendingDeletion leasePendingDeletion) {
        KinesisClientLease lease = leasePendingDeletion.lease();
        if (lease == null) {
            LOG.warn((Object)("Cannot enqueue lease " + lease.getLeaseKey() + " for deferred deletion - instance doesn't hold the lease for that shard."));
        } else {
            LOG.debug((Object)("Enqueuing lease " + lease.getLeaseKey() + " for deferred deletion."));
            if (!this.deletionQueue.add(leasePendingDeletion)) {
                LOG.warn((Object)("Unable to enqueue lease " + lease.getLeaseKey() + " for deletion."));
            }
        }
    }

    public boolean isEnqueuedForDeletion(LeasePendingDeletion leasePendingDeletion) {
        return this.deletionQueue.contains(leasePendingDeletion);
    }

    private int leasesPendingDeletion() {
        return this.deletionQueue.size();
    }

    private boolean timeToCheckForCompletedShard() {
        return this.completedLeaseStopwatch.elapsed(TimeUnit.MILLISECONDS) >= this.completedLeaseCleanupIntervalMillis;
    }

    private boolean timeToCheckForGarbageShard() {
        return this.garbageLeaseStopwatch.elapsed(TimeUnit.MILLISECONDS) >= this.garbageLeaseCleanupIntervalMillis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LeaseCleanupResult cleanupLease(LeasePendingDeletion leasePendingDeletion, boolean timeToCheckForCompletedShard, boolean timeToCheckForGarbageShard) throws DependencyException, ProvisionedThroughputException, InvalidStateException {
        KinesisClientLease lease = leasePendingDeletion.lease();
        ShardInfo shardInfo = leasePendingDeletion.shardInfo();
        boolean cleanedUpCompletedLease = false;
        boolean cleanedUpGarbageLease = false;
        boolean alreadyCheckedForGarbageCollection = false;
        boolean wereChildShardsPresent = false;
        boolean wasResourceNotFound = false;
        String cleanupFailureReason = "";
        try {
            if (this.cleanupLeasesUponShardCompletion && timeToCheckForCompletedShard) {
                KinesisClientLease leaseFromDDB = this.leaseManager.getLease(shardInfo.getShardId());
                if (leaseFromDDB != null) {
                    Set<String> childShardKeys = leaseFromDDB.getChildShardIds();
                    if (CollectionUtils.isNullOrEmpty(childShardKeys)) {
                        try {
                            childShardKeys = this.getChildShardsFromService(shardInfo);
                            if (CollectionUtils.isNullOrEmpty(childShardKeys)) {
                                LOG.error((Object)("No child shards returned from service for shard " + shardInfo.getShardId()));
                                throw new InvalidStateException("No child shards found for this supposedly closed shard in both local DDB and in service " + shardInfo.getShardId());
                            }
                            wereChildShardsPresent = true;
                            this.updateLeaseWithChildShards(leasePendingDeletion, childShardKeys);
                        }
                        finally {
                            alreadyCheckedForGarbageCollection = true;
                        }
                    } else {
                        wereChildShardsPresent = true;
                    }
                    try {
                        CompletedShardResult completedShardResult = this.cleanupLeaseForCompletedShard(lease, childShardKeys);
                        cleanedUpCompletedLease = completedShardResult.cleanedUp();
                        cleanupFailureReason = completedShardResult.failureMsg();
                    }
                    catch (Exception e) {
                        LOG.warn((Object)("Unable to cleanup lease for shard " + shardInfo.getShardId() + " due to " + e.getMessage()));
                    }
                } else {
                    LOG.info((Object)("Lease not present in lease table while cleaning the shard " + shardInfo.getShardId()));
                    cleanedUpCompletedLease = true;
                }
            } else {
                cleanupFailureReason = "Configuration/Interval condition not satisfied to execute lease cleanup this cycle";
            }
            if (!cleanedUpCompletedLease && !alreadyCheckedForGarbageCollection && timeToCheckForGarbageShard) {
                wereChildShardsPresent = !CollectionUtils.isNullOrEmpty(this.getChildShardsFromService(shardInfo));
            }
        }
        catch (ResourceNotFoundException e) {
            wasResourceNotFound = true;
            cleanedUpGarbageLease = this.cleanupLeaseForGarbageShard(lease);
            cleanupFailureReason = cleanedUpGarbageLease ? "" : "DDB Lease Deletion Failed";
        }
        catch (Exception e) {
            LOG.warn((Object)("Unable to cleanup lease for shard " + shardInfo.getShardId() + " : " + e.getMessage()));
            cleanupFailureReason = e.getMessage();
        }
        return new LeaseCleanupResult(cleanedUpCompletedLease, cleanedUpGarbageLease, wereChildShardsPresent, wasResourceNotFound, cleanupFailureReason);
    }

    private Set<String> getChildShardsFromService(ShardInfo shardInfo) {
        String iterator = this.kinesisProxy.getIterator(shardInfo.getShardId(), ShardIteratorType.LATEST.toString());
        return this.kinesisProxy.get(iterator, this.maxRecords).getChildShards().stream().map(c -> c.getShardId()).collect(Collectors.toSet());
    }

    private boolean cleanupLeaseForGarbageShard(KinesisClientLease lease) throws DependencyException, ProvisionedThroughputException, InvalidStateException {
        LOG.info((Object)("Deleting lease " + lease.getLeaseKey() + " as it is not present in the stream."));
        try {
            this.leaseManager.deleteLease(lease);
        }
        catch (Exception e) {
            LOG.warn((Object)("Lease deletion failed for " + lease.getLeaseKey() + " due to " + e.getMessage()));
            return false;
        }
        return true;
    }

    private boolean allParentShardLeasesDeleted(KinesisClientLease lease) throws DependencyException, ProvisionedThroughputException, InvalidStateException {
        for (String parentShard : lease.getParentShardIds()) {
            KinesisClientLease parentLease = this.leaseManager.getLease(parentShard);
            if (parentLease == null) continue;
            LOG.warn((Object)("Lease " + lease.getLeaseKey() + " has a parent lease " + parentLease.getLeaseKey() + " which is still present in the lease table, skipping deletion for this lease."));
            return false;
        }
        return true;
    }

    private CompletedShardResult cleanupLeaseForCompletedShard(KinesisClientLease lease, Set<String> childShardLeaseKeys) throws DependencyException, ProvisionedThroughputException, InvalidStateException, IllegalStateException {
        HashSet<String> processedChildShardLeaseKeys = new HashSet<String>();
        for (String childShardLeaseKey : childShardLeaseKeys) {
            KinesisClientLease childShardLease = Optional.ofNullable(this.leaseManager.getLease(childShardLeaseKey)).orElseThrow(() -> new IllegalStateException("Child lease " + childShardLeaseKey + " for completed shard not found in lease table - not cleaning up lease " + lease));
            if (childShardLease.getCheckpoint().equals(ExtendedSequenceNumber.TRIM_HORIZON) || childShardLease.getCheckpoint().equals(ExtendedSequenceNumber.AT_TIMESTAMP)) continue;
            processedChildShardLeaseKeys.add(childShardLease.getLeaseKey());
        }
        boolean parentShardsDeleted = this.allParentShardLeasesDeleted(lease);
        boolean childrenStartedProcessing = Objects.equals(childShardLeaseKeys, processedChildShardLeaseKeys);
        if (!parentShardsDeleted || !childrenStartedProcessing) {
            return new CompletedShardResult(false, !parentShardsDeleted ? "Parent shard(s) not deleted yet" : "Child shard(s) yet to begin processing");
        }
        LOG.info((Object)("Deleting lease " + lease.getLeaseKey() + " as it has been completely processed and processing of child shard(s) has begun."));
        this.leaseManager.deleteLease(lease);
        return new CompletedShardResult(true, "");
    }

    private void updateLeaseWithChildShards(LeasePendingDeletion leasePendingDeletion, Set<String> childShardKeys) throws DependencyException, ProvisionedThroughputException, InvalidStateException {
        KinesisClientLease updatedLease = leasePendingDeletion.lease();
        updatedLease.setChildShardIds(childShardKeys);
        this.leaseManager.updateLeaseWithMetaInfo(updatedLease, UpdateField.CHILD_SHARDS);
    }

    @VisibleForTesting
    void cleanupLeases() {
        LOG.info((Object)("Number of pending leases to clean before the scan : " + this.leasesPendingDeletion()));
        if (this.deletionQueue.isEmpty()) {
            LOG.debug((Object)"No leases pending deletion.");
        } else if (this.timeToCheckForCompletedShard() | this.timeToCheckForGarbageShard()) {
            ConcurrentLinkedQueue<LeasePendingDeletion> failedDeletions = new ConcurrentLinkedQueue<LeasePendingDeletion>();
            boolean completedLeaseCleanedUp = false;
            boolean garbageLeaseCleanedUp = false;
            LOG.debug((Object)("Attempting to clean up " + this.deletionQueue.size() + " lease(s)."));
            while (!this.deletionQueue.isEmpty()) {
                LeasePendingDeletion leasePendingDeletion = this.deletionQueue.poll();
                String leaseKey = leasePendingDeletion.lease().getLeaseKey();
                boolean deletionSucceeded = false;
                try {
                    LeaseCleanupResult leaseCleanupResult = this.cleanupLease(leasePendingDeletion, this.timeToCheckForCompletedShard(), this.timeToCheckForGarbageShard());
                    completedLeaseCleanedUp |= leaseCleanupResult.cleanedUpCompletedLease();
                    garbageLeaseCleanedUp |= leaseCleanupResult.cleanedUpGarbageLease();
                    if (leaseCleanupResult.leaseCleanedUp()) {
                        LOG.debug((Object)("Successfully cleaned up lease " + leaseKey));
                        deletionSucceeded = true;
                    } else {
                        LOG.warn((Object)("Unable to clean up lease " + leaseKey + " due to " + leaseCleanupResult));
                    }
                }
                catch (Exception e) {
                    LOG.error((Object)("Failed to cleanup lease " + leaseKey + ". Will re-enqueue for deletion and retry on next scheduled execution."), (Throwable)e);
                }
                if (deletionSucceeded) continue;
                LOG.debug((Object)("Did not cleanup lease " + leaseKey + ". Re-enqueueing for deletion."));
                failedDeletions.add(leasePendingDeletion);
            }
            if (completedLeaseCleanedUp) {
                LOG.debug((Object)"At least one completed lease was cleaned up - restarting interval");
                this.completedLeaseStopwatch.reset().start();
            }
            if (garbageLeaseCleanedUp) {
                LOG.debug((Object)"At least one garbage lease was cleaned up - restarting interval");
                this.garbageLeaseStopwatch.reset().start();
            }
            this.deletionQueue.addAll(failedDeletions);
            LOG.info((Object)("Number of pending leases to clean after the scan : " + this.leasesPendingDeletion()));
        }
    }

    LeaseCleanupManager(@NonNull IKinesisProxy kinesisProxy, @NonNull ILeaseManager<KinesisClientLease> leaseManager, @NonNull ScheduledExecutorService deletionThreadPool, @NonNull IMetricsFactory metricsFactory, boolean cleanupLeasesUponShardCompletion, long leaseCleanupIntervalMillis, long completedLeaseCleanupIntervalMillis, long garbageLeaseCleanupIntervalMillis, int maxRecords) {
        if (kinesisProxy == null) {
            throw new NullPointerException("kinesisProxy");
        }
        if (leaseManager == null) {
            throw new NullPointerException("leaseManager");
        }
        if (deletionThreadPool == null) {
            throw new NullPointerException("deletionThreadPool");
        }
        if (metricsFactory == null) {
            throw new NullPointerException("metricsFactory");
        }
        this.kinesisProxy = kinesisProxy;
        this.leaseManager = leaseManager;
        this.deletionThreadPool = deletionThreadPool;
        this.metricsFactory = metricsFactory;
        this.cleanupLeasesUponShardCompletion = cleanupLeasesUponShardCompletion;
        this.leaseCleanupIntervalMillis = leaseCleanupIntervalMillis;
        this.completedLeaseCleanupIntervalMillis = completedLeaseCleanupIntervalMillis;
        this.garbageLeaseCleanupIntervalMillis = garbageLeaseCleanupIntervalMillis;
        this.maxRecords = maxRecords;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LeaseCleanupManager)) {
            return false;
        }
        LeaseCleanupManager other = (LeaseCleanupManager)o;
        if (!other.canEqual(this)) {
            return false;
        }
        IKinesisProxy this$kinesisProxy = this.kinesisProxy;
        IKinesisProxy other$kinesisProxy = other.kinesisProxy;
        if (this$kinesisProxy == null ? other$kinesisProxy != null : !this$kinesisProxy.equals(other$kinesisProxy)) {
            return false;
        }
        ILeaseManager<KinesisClientLease> this$leaseManager = this.leaseManager;
        ILeaseManager<KinesisClientLease> other$leaseManager = other.leaseManager;
        if (this$leaseManager == null ? other$leaseManager != null : !this$leaseManager.equals(other$leaseManager)) {
            return false;
        }
        ScheduledExecutorService this$deletionThreadPool = this.deletionThreadPool;
        ScheduledExecutorService other$deletionThreadPool = other.deletionThreadPool;
        if (this$deletionThreadPool == null ? other$deletionThreadPool != null : !this$deletionThreadPool.equals(other$deletionThreadPool)) {
            return false;
        }
        IMetricsFactory this$metricsFactory = this.metricsFactory;
        IMetricsFactory other$metricsFactory = other.metricsFactory;
        if (this$metricsFactory == null ? other$metricsFactory != null : !this$metricsFactory.equals(other$metricsFactory)) {
            return false;
        }
        if (this.cleanupLeasesUponShardCompletion != other.cleanupLeasesUponShardCompletion) {
            return false;
        }
        if (this.leaseCleanupIntervalMillis != other.leaseCleanupIntervalMillis) {
            return false;
        }
        if (this.completedLeaseCleanupIntervalMillis != other.completedLeaseCleanupIntervalMillis) {
            return false;
        }
        if (this.garbageLeaseCleanupIntervalMillis != other.garbageLeaseCleanupIntervalMillis) {
            return false;
        }
        if (this.maxRecords != other.maxRecords) {
            return false;
        }
        Stopwatch this$completedLeaseStopwatch = this.completedLeaseStopwatch;
        Stopwatch other$completedLeaseStopwatch = other.completedLeaseStopwatch;
        if (this$completedLeaseStopwatch == null ? other$completedLeaseStopwatch != null : !this$completedLeaseStopwatch.equals(other$completedLeaseStopwatch)) {
            return false;
        }
        Stopwatch this$garbageLeaseStopwatch = this.garbageLeaseStopwatch;
        Stopwatch other$garbageLeaseStopwatch = other.garbageLeaseStopwatch;
        if (this$garbageLeaseStopwatch == null ? other$garbageLeaseStopwatch != null : !this$garbageLeaseStopwatch.equals(other$garbageLeaseStopwatch)) {
            return false;
        }
        Queue<LeasePendingDeletion> this$deletionQueue = this.deletionQueue;
        Queue<LeasePendingDeletion> other$deletionQueue = other.deletionQueue;
        if (this$deletionQueue == null ? other$deletionQueue != null : !this$deletionQueue.equals(other$deletionQueue)) {
            return false;
        }
        return this.isRunning() == other.isRunning();
    }

    protected boolean canEqual(Object other) {
        return other instanceof LeaseCleanupManager;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        IKinesisProxy $kinesisProxy = this.kinesisProxy;
        result = result * 59 + ($kinesisProxy == null ? 43 : $kinesisProxy.hashCode());
        ILeaseManager<KinesisClientLease> $leaseManager = this.leaseManager;
        result = result * 59 + ($leaseManager == null ? 43 : $leaseManager.hashCode());
        ScheduledExecutorService $deletionThreadPool = this.deletionThreadPool;
        result = result * 59 + ($deletionThreadPool == null ? 43 : $deletionThreadPool.hashCode());
        IMetricsFactory $metricsFactory = this.metricsFactory;
        result = result * 59 + ($metricsFactory == null ? 43 : $metricsFactory.hashCode());
        result = result * 59 + (this.cleanupLeasesUponShardCompletion ? 79 : 97);
        long $leaseCleanupIntervalMillis = this.leaseCleanupIntervalMillis;
        result = result * 59 + (int)($leaseCleanupIntervalMillis >>> 32 ^ $leaseCleanupIntervalMillis);
        long $completedLeaseCleanupIntervalMillis = this.completedLeaseCleanupIntervalMillis;
        result = result * 59 + (int)($completedLeaseCleanupIntervalMillis >>> 32 ^ $completedLeaseCleanupIntervalMillis);
        long $garbageLeaseCleanupIntervalMillis = this.garbageLeaseCleanupIntervalMillis;
        result = result * 59 + (int)($garbageLeaseCleanupIntervalMillis >>> 32 ^ $garbageLeaseCleanupIntervalMillis);
        result = result * 59 + this.maxRecords;
        Stopwatch $completedLeaseStopwatch = this.completedLeaseStopwatch;
        result = result * 59 + ($completedLeaseStopwatch == null ? 43 : $completedLeaseStopwatch.hashCode());
        Stopwatch $garbageLeaseStopwatch = this.garbageLeaseStopwatch;
        result = result * 59 + ($garbageLeaseStopwatch == null ? 43 : $garbageLeaseStopwatch.hashCode());
        Queue<LeasePendingDeletion> $deletionQueue = this.deletionQueue;
        result = result * 59 + ($deletionQueue == null ? 43 : $deletionQueue.hashCode());
        result = result * 59 + (this.isRunning() ? 79 : 97);
        return result;
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    private static final class CompletedShardResult {
        private final boolean cleanedUp;
        private final String failureMsg;

        @ConstructorProperties(value={"cleanedUp", "failureMsg"})
        public CompletedShardResult(boolean cleanedUp, String failureMsg) {
            this.cleanedUp = cleanedUp;
            this.failureMsg = failureMsg;
        }

        public boolean cleanedUp() {
            return this.cleanedUp;
        }

        public String failureMsg() {
            return this.failureMsg;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CompletedShardResult)) {
                return false;
            }
            CompletedShardResult other = (CompletedShardResult)o;
            if (this.cleanedUp() != other.cleanedUp()) {
                return false;
            }
            String this$failureMsg = this.failureMsg();
            String other$failureMsg = other.failureMsg();
            return !(this$failureMsg == null ? other$failureMsg != null : !this$failureMsg.equals(other$failureMsg));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.cleanedUp() ? 79 : 97);
            String $failureMsg = this.failureMsg();
            result = result * 59 + ($failureMsg == null ? 43 : $failureMsg.hashCode());
            return result;
        }

        public String toString() {
            return "LeaseCleanupManager.CompletedShardResult(cleanedUp=" + this.cleanedUp() + ", failureMsg=" + this.failureMsg() + ")";
        }
    }

    public static final class LeaseCleanupResult {
        private final boolean cleanedUpCompletedLease;
        private final boolean cleanedUpGarbageLease;
        private final boolean wereChildShardsPresent;
        private final boolean wasResourceNotFound;
        private final String cleanupFailureReason;

        public boolean leaseCleanedUp() {
            return this.cleanedUpCompletedLease | this.cleanedUpGarbageLease;
        }

        @ConstructorProperties(value={"cleanedUpCompletedLease", "cleanedUpGarbageLease", "wereChildShardsPresent", "wasResourceNotFound", "cleanupFailureReason"})
        public LeaseCleanupResult(boolean cleanedUpCompletedLease, boolean cleanedUpGarbageLease, boolean wereChildShardsPresent, boolean wasResourceNotFound, String cleanupFailureReason) {
            this.cleanedUpCompletedLease = cleanedUpCompletedLease;
            this.cleanedUpGarbageLease = cleanedUpGarbageLease;
            this.wereChildShardsPresent = wereChildShardsPresent;
            this.wasResourceNotFound = wasResourceNotFound;
            this.cleanupFailureReason = cleanupFailureReason;
        }

        public boolean cleanedUpCompletedLease() {
            return this.cleanedUpCompletedLease;
        }

        public boolean cleanedUpGarbageLease() {
            return this.cleanedUpGarbageLease;
        }

        public boolean wereChildShardsPresent() {
            return this.wereChildShardsPresent;
        }

        public boolean wasResourceNotFound() {
            return this.wasResourceNotFound;
        }

        public String cleanupFailureReason() {
            return this.cleanupFailureReason;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof LeaseCleanupResult)) {
                return false;
            }
            LeaseCleanupResult other = (LeaseCleanupResult)o;
            if (this.cleanedUpCompletedLease() != other.cleanedUpCompletedLease()) {
                return false;
            }
            if (this.cleanedUpGarbageLease() != other.cleanedUpGarbageLease()) {
                return false;
            }
            if (this.wereChildShardsPresent() != other.wereChildShardsPresent()) {
                return false;
            }
            if (this.wasResourceNotFound() != other.wasResourceNotFound()) {
                return false;
            }
            String this$cleanupFailureReason = this.cleanupFailureReason();
            String other$cleanupFailureReason = other.cleanupFailureReason();
            return !(this$cleanupFailureReason == null ? other$cleanupFailureReason != null : !this$cleanupFailureReason.equals(other$cleanupFailureReason));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.cleanedUpCompletedLease() ? 79 : 97);
            result = result * 59 + (this.cleanedUpGarbageLease() ? 79 : 97);
            result = result * 59 + (this.wereChildShardsPresent() ? 79 : 97);
            result = result * 59 + (this.wasResourceNotFound() ? 79 : 97);
            String $cleanupFailureReason = this.cleanupFailureReason();
            result = result * 59 + ($cleanupFailureReason == null ? 43 : $cleanupFailureReason.hashCode());
            return result;
        }

        public String toString() {
            return "LeaseCleanupManager.LeaseCleanupResult(cleanedUpCompletedLease=" + this.cleanedUpCompletedLease() + ", cleanedUpGarbageLease=" + this.cleanedUpGarbageLease() + ", wereChildShardsPresent=" + this.wereChildShardsPresent() + ", wasResourceNotFound=" + this.wasResourceNotFound() + ", cleanupFailureReason=" + this.cleanupFailureReason() + ")";
        }
    }

    private class LeaseCleanupThread
    implements Runnable {
        private LeaseCleanupThread() {
        }

        @Override
        public void run() {
            LeaseCleanupManager.this.cleanupLeases();
        }
    }
}

