/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesis.clientlibrary.lib.worker;

import com.amazonaws.services.kinesis.clientlibrary.interfaces.IRecordProcessorCheckpointer;
import com.amazonaws.services.kinesis.clientlibrary.interfaces.v2.IRecordProcessor;
import com.amazonaws.services.kinesis.clientlibrary.interfaces.v2.IShutdownNotificationAware;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.ITask;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.ShardInfo;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.ShutdownNotification;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.TaskResult;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.TaskType;

class ShutdownNotificationTask
implements ITask {
    private final IRecordProcessor recordProcessor;
    private final IRecordProcessorCheckpointer recordProcessorCheckpointer;
    private final ShutdownNotification shutdownNotification;
    private final ShardInfo shardInfo;

    ShutdownNotificationTask(IRecordProcessor recordProcessor, IRecordProcessorCheckpointer recordProcessorCheckpointer, ShutdownNotification shutdownNotification, ShardInfo shardInfo) {
        this.recordProcessor = recordProcessor;
        this.recordProcessorCheckpointer = recordProcessorCheckpointer;
        this.shutdownNotification = shutdownNotification;
        this.shardInfo = shardInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TaskResult call() {
        try {
            if (this.recordProcessor instanceof IShutdownNotificationAware) {
                IShutdownNotificationAware shutdownNotificationAware = (IShutdownNotificationAware)((Object)this.recordProcessor);
                try {
                    shutdownNotificationAware.shutdownRequested(this.recordProcessorCheckpointer);
                }
                catch (Exception ex) {
                    TaskResult taskResult = new TaskResult(ex);
                    this.shutdownNotification.shutdownNotificationComplete();
                    return taskResult;
                }
            }
            TaskResult taskResult = new TaskResult(null);
            return taskResult;
        }
        finally {
            this.shutdownNotification.shutdownNotificationComplete();
        }
    }

    @Override
    public TaskType getTaskType() {
        return TaskType.SHUTDOWN_NOTIFICATION;
    }
}

