/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesis.clientlibrary.lib.worker;

import com.amazonaws.services.kinesis.clientlibrary.lib.worker.LeaderDecider;
import com.amazonaws.services.kinesis.leases.exceptions.DependencyException;
import com.amazonaws.services.kinesis.leases.exceptions.InvalidStateException;
import com.amazonaws.services.kinesis.leases.exceptions.ProvisionedThroughputException;
import com.amazonaws.services.kinesis.leases.impl.KinesisClientLease;
import com.amazonaws.services.kinesis.leases.impl.Lease;
import com.amazonaws.services.kinesis.leases.interfaces.ILeaseManager;
import com.amazonaws.util.CollectionUtils;
import java.time.Instant;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.BooleanSupplier;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class DeterministicShuffleShardSyncLeaderDecider
implements LeaderDecider {
    static final int DETERMINISTIC_SHUFFLE_SEED = 1947;
    private static final Log LOG = LogFactory.getLog(DeterministicShuffleShardSyncLeaderDecider.class);
    private static final long ELECTION_INITIAL_DELAY_MILLIS = 60000L;
    private static final long ELECTION_SCHEDULING_INTERVAL_MILLIS = 300000L;
    private static final int AWAIT_TERMINATION_MILLIS = 5000;
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final ILeaseManager<KinesisClientLease> leaseManager;
    private final int numPeriodicShardSyncWorkers;
    private final ScheduledExecutorService leaderElectionThreadPool;
    private volatile Set<String> leaders;

    DeterministicShuffleShardSyncLeaderDecider(ILeaseManager<KinesisClientLease> leaseManager, ScheduledExecutorService leaderElectionThreadPool, int numPeriodicShardSyncWorkers) {
        this.leaseManager = leaseManager;
        this.leaderElectionThreadPool = leaderElectionThreadPool;
        this.numPeriodicShardSyncWorkers = numPeriodicShardSyncWorkers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void electLeaders() {
        try {
            LOG.debug((Object)("Started leader election at: " + Instant.now()));
            List<KinesisClientLease> leases = this.leaseManager.listLeases();
            List uniqueHosts = leases.stream().map(Lease::getLeaseOwner).filter(owner -> owner != null).distinct().sorted().collect(Collectors.toList());
            Collections.shuffle(uniqueHosts, new Random(1947L));
            int numShardSyncWorkers = Math.min(uniqueHosts.size(), this.numPeriodicShardSyncWorkers);
            this.readWriteLock.writeLock().lock();
            this.leaders = new HashSet(uniqueHosts.subList(0, numShardSyncWorkers));
            LOG.info((Object)("Elected leaders: " + String.join((CharSequence)", ", this.leaders)));
            LOG.debug((Object)("Completed leader election at: " + System.currentTimeMillis()));
        }
        catch (DependencyException | InvalidStateException | ProvisionedThroughputException e) {
            LOG.error((Object)"Exception occurred while trying to fetch all leases for leader election", (Throwable)e);
        }
        catch (Throwable t) {
            LOG.error((Object)"Unknown exception during leader election.", t);
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    private boolean isWorkerLeaderForShardSync(String workerId) {
        return CollectionUtils.isNullOrEmpty(this.leaders) || !CollectionUtils.isNullOrEmpty(this.leaders) && this.leaders.contains(workerId);
    }

    @Override
    public synchronized Boolean isLeader(String workerId) {
        if (this.executeConditionCheckWithReadLock(() -> CollectionUtils.isNullOrEmpty(this.leaders))) {
            this.electLeaders();
            this.leaderElectionThreadPool.scheduleWithFixedDelay(this::electLeaders, 60000L, 300000L, TimeUnit.MILLISECONDS);
        }
        return this.executeConditionCheckWithReadLock(() -> this.isWorkerLeaderForShardSync(workerId));
    }

    @Override
    public synchronized void shutdown() {
        try {
            this.leaderElectionThreadPool.shutdown();
            if (this.leaderElectionThreadPool.awaitTermination(5000L, TimeUnit.MILLISECONDS)) {
                LOG.info((Object)"Successfully stopped leader election on the worker");
            } else {
                this.leaderElectionThreadPool.shutdownNow();
                LOG.info((Object)String.format("Stopped leader election thread after awaiting termination for %d milliseconds", 5000));
            }
        }
        catch (InterruptedException e) {
            LOG.debug((Object)"Encountered InterruptedException while awaiting leader election threadPool termination");
        }
    }

    private boolean executeConditionCheckWithReadLock(BooleanSupplier action) {
        try {
            this.readWriteLock.readLock().lock();
            boolean bl = action.getAsBoolean();
            return bl;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }
}

