/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.tools.nodetool;

import io.airlift.airline.Command;
import java.net.UnknownHostException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.locator.EndpointSnitchInfoMBean;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.tools.NodeProbe;
import org.apache.cassandra.tools.NodeTool;
import org.apache.cassandra.tools.nodetool.formatter.TableBuilder;

@Command(name="listpendinghints", description="Print all pending hints that this node has")
public class ListPendingHints
extends NodeTool.NodeToolCmd {
    @Override
    public void execute(NodeProbe probe) {
        List<Map<String, String>> pendingHints = probe.listPendingHints();
        if (pendingHints.isEmpty()) {
            probe.output().out.println("This node does not have any pending hints");
        } else {
            Map<String, String> endpointMap = probe.getHostIdToEndpointWithPort();
            Map<String, String> simpleStates = probe.getSimpleStatesWithPort();
            EndpointSnitchInfoMBean epSnitchInfo = probe.getEndpointSnitchInfoProxy();
            DateTimeFormatter dtf = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss,SSS");
            TableBuilder tableBuilder = new TableBuilder();
            tableBuilder.add("Host ID", "Address", "Rack", "DC", "Status", "Total files", "Newest", "Oldest");
            for (Map<String, String> hintInfo : pendingHints) {
                String endpoint = hintInfo.get("host_id");
                String totalFiles = hintInfo.get("total_files");
                LocalDateTime newest = Instant.ofEpochMilli(Long.parseLong(hintInfo.get("newest_timestamp"))).atZone(ZoneId.of("UTC")).toLocalDateTime();
                LocalDateTime oldest = Instant.ofEpochMilli(Long.parseLong(hintInfo.get("oldest_timestamp"))).atZone(ZoneId.of("UTC")).toLocalDateTime();
                String address = endpointMap.get(endpoint);
                String rack = null;
                String dc = null;
                String status = null;
                try {
                    rack = epSnitchInfo.getRack(address);
                    dc = epSnitchInfo.getDatacenter(address);
                    status = simpleStates.getOrDefault(InetAddressAndPort.getByName(address).toString(), "Unknown");
                }
                catch (UnknownHostException e) {
                    rack = rack != null ? rack : "Unknown";
                    dc = dc != null ? dc : "Unknown";
                    status = "Unknown";
                }
                tableBuilder.add(endpoint, address, rack, dc, status, String.valueOf(totalFiles), dtf.format(newest), dtf.format(oldest));
            }
            tableBuilder.printTo(probe.output().out);
        }
    }
}

