/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.tools;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.Directories;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.compaction.CompactionManager;
import org.apache.cassandra.db.compaction.Verifier;
import org.apache.cassandra.dht.Murmur3Partitioner;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.io.sstable.Component;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.schema.Schema;
import org.apache.cassandra.tools.BulkLoader;
import org.apache.cassandra.tools.Util;
import org.apache.cassandra.utils.JVMStabilityInspector;
import org.apache.cassandra.utils.OutputHandler;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.ParseException;

public class StandaloneVerifier {
    private static final String TOOL_NAME = "sstableverify";
    private static final String VERBOSE_OPTION = "verbose";
    private static final String EXTENDED_OPTION = "extended";
    private static final String DEBUG_OPTION = "debug";
    private static final String HELP_OPTION = "help";
    private static final String CHECK_VERSION = "check_version";
    private static final String MUTATE_REPAIR_STATUS = "mutate_repair_status";
    private static final String QUICK = "quick";
    private static final String FORCE = "force";
    private static final String TOKEN_RANGE = "token_range";

    public static void main(String[] args) {
        Options options = Options.parseArgs(args);
        if (!options.force) {
            System.err.println("verify will not run without -f or --force. See CASSANDRA-17017 for details.");
            Options.printUsage(Options.getCmdLineOptions());
            System.exit(1);
        }
        StandaloneVerifier.initDatabaseDescriptorForTool();
        System.out.println("sstableverify using the following options: " + options);
        try {
            Schema.instance.loadFromDisk();
            boolean hasFailed = false;
            if (Schema.instance.getTableMetadataRef(options.keyspaceName, options.cfName) == null) {
                throw new IllegalArgumentException(String.format("Unknown keyspace/table %s.%s", options.keyspaceName, options.cfName));
            }
            Keyspace keyspace = Keyspace.openWithoutSSTables(options.keyspaceName);
            ColumnFamilyStore cfs = keyspace.getColumnFamilyStore(options.cfName);
            OutputHandler.SystemOutput handler = new OutputHandler.SystemOutput(options.verbose, options.debug);
            Directories.SSTableLister lister = cfs.getDirectories().sstableLister(Directories.OnTxnErr.THROW).skipTemporary(true);
            ArrayList<SSTableReader> sstables = new ArrayList<SSTableReader>();
            for (Map.Entry<Descriptor, Set<Component>> entry : lister.list().entrySet()) {
                Set<Component> components = entry.getValue();
                if (!components.contains(Component.DATA) || !components.contains(Component.PRIMARY_INDEX)) continue;
                try {
                    SSTableReader sstable = SSTableReader.openNoValidation(entry.getKey(), components, cfs);
                    sstables.add(sstable);
                }
                catch (Exception e) {
                    JVMStabilityInspector.inspectThrowable(e);
                    System.err.println(String.format("Error Loading %s: %s", entry.getKey(), e.getMessage()));
                    if (options.debug) {
                        e.printStackTrace(System.err);
                    }
                    System.exit(1);
                }
            }
            Verifier.Options verifyOptions = Verifier.options().invokeDiskFailurePolicy(false).extendedVerification(options.extended).checkVersion(options.checkVersion).mutateRepairStatus(options.mutateRepairStatus).checkOwnsTokens(!options.tokens.isEmpty()).tokenLookup(ignore -> options.tokens).build();
            handler.output("Running verifier with the following options: " + verifyOptions);
            for (SSTableReader sstable : sstables) {
                try {
                    Verifier verifier = new Verifier(cfs, sstable, handler, true, verifyOptions);
                    Throwable throwable = null;
                    try {
                        verifier.verify();
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (verifier == null) continue;
                        if (throwable != null) {
                            try {
                                verifier.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        verifier.close();
                    }
                }
                catch (Exception e) {
                    handler.warn(String.format("Error verifying %s: %s", sstable, e.getMessage()), e);
                    hasFailed = true;
                }
            }
            CompactionManager.instance.finishCompactionsAndShutdown(5L, TimeUnit.MINUTES);
            System.exit(hasFailed ? 1 : 0);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            if (options.debug) {
                e.printStackTrace(System.err);
            }
            System.exit(1);
        }
    }

    private static void initDatabaseDescriptorForTool() {
        if (Boolean.getBoolean(Util.ALLOW_TOOL_REINIT_FOR_TEST)) {
            DatabaseDescriptor.toolInitialization(false);
        } else {
            Util.initDatabaseDescriptor();
        }
    }

    private static Range<Token> parseTokenRange(String line) {
        String[] split = line.split(",");
        if (split.length != 2) {
            throw new IllegalArgumentException("Unable to parse token range from " + line + "; format is left,right but saw " + split.length + " parts");
        }
        long left = Long.parseLong(split[0]);
        long right = Long.parseLong(split[1]);
        return new Range<Token>(new Murmur3Partitioner.LongToken(left), new Murmur3Partitioner.LongToken(right));
    }

    private static class Options {
        public final String keyspaceName;
        public final String cfName;
        public boolean debug;
        public boolean verbose;
        public boolean extended;
        public boolean checkVersion;
        public boolean mutateRepairStatus;
        public boolean quick;
        public boolean force;
        public Collection<Range<Token>> tokens;

        private Options(String keyspaceName, String cfName) {
            this.keyspaceName = keyspaceName;
            this.cfName = cfName;
        }

        public static Options parseArgs(String[] cmdArgs) {
            GnuParser parser = new GnuParser();
            BulkLoader.CmdLineOptions options = Options.getCmdLineOptions();
            try {
                String[] args;
                CommandLine cmd = parser.parse((org.apache.commons.cli.Options)options, cmdArgs, false);
                if (cmd.hasOption(StandaloneVerifier.HELP_OPTION)) {
                    Options.printUsage(options);
                    System.exit(0);
                }
                if ((args = cmd.getArgs()).length != 2) {
                    String prefix = args.length < 2 ? "Missing" : "Too many";
                    System.err.println(prefix + " arguments");
                    Options.printUsage(options);
                    System.exit(1);
                }
                String keyspaceName = args[0];
                String cfName = args[1];
                Options opts = new Options(keyspaceName, cfName);
                opts.debug = cmd.hasOption(StandaloneVerifier.DEBUG_OPTION);
                opts.verbose = cmd.hasOption(StandaloneVerifier.VERBOSE_OPTION);
                opts.extended = cmd.hasOption(StandaloneVerifier.EXTENDED_OPTION);
                opts.checkVersion = cmd.hasOption(StandaloneVerifier.CHECK_VERSION);
                opts.mutateRepairStatus = cmd.hasOption(StandaloneVerifier.MUTATE_REPAIR_STATUS);
                opts.quick = cmd.hasOption(StandaloneVerifier.QUICK);
                opts.force = cmd.hasOption(StandaloneVerifier.FORCE);
                opts.tokens = cmd.hasOption(StandaloneVerifier.TOKEN_RANGE) ? (Collection<Object>)Stream.of(cmd.getOptionValues(StandaloneVerifier.TOKEN_RANGE)).map(x$0 -> StandaloneVerifier.parseTokenRange(x$0)).collect(Collectors.toSet()) : Collections.emptyList();
                return opts;
            }
            catch (ParseException e) {
                Options.errorMsg(e.getMessage(), options);
                return null;
            }
        }

        public String toString() {
            return "Options{keyspaceName='" + this.keyspaceName + '\'' + ", cfName='" + this.cfName + '\'' + ", debug=" + this.debug + ", verbose=" + this.verbose + ", extended=" + this.extended + ", checkVersion=" + this.checkVersion + ", mutateRepairStatus=" + this.mutateRepairStatus + ", quick=" + this.quick + ", tokens=" + this.tokens + '}';
        }

        private static void errorMsg(String msg, BulkLoader.CmdLineOptions options) {
            System.err.println(msg);
            Options.printUsage(options);
            System.exit(1);
        }

        private static BulkLoader.CmdLineOptions getCmdLineOptions() {
            BulkLoader.CmdLineOptions options = new BulkLoader.CmdLineOptions();
            options.addOption(null, StandaloneVerifier.DEBUG_OPTION, "display stack traces");
            options.addOption("e", StandaloneVerifier.EXTENDED_OPTION, "extended verification");
            options.addOption("v", StandaloneVerifier.VERBOSE_OPTION, "verbose output");
            options.addOption("h", StandaloneVerifier.HELP_OPTION, "display this help message");
            options.addOption("c", StandaloneVerifier.CHECK_VERSION, "make sure sstables are the latest version");
            options.addOption("r", StandaloneVerifier.MUTATE_REPAIR_STATUS, "don't mutate repair status");
            options.addOption("q", StandaloneVerifier.QUICK, "do a quick check, don't read all data");
            options.addOption("f", StandaloneVerifier.FORCE, "force verify - see CASSANDRA-17017");
            options.addOptionList("t", StandaloneVerifier.TOKEN_RANGE, "range", "long token range of the format left,right. This may be provided multiple times to define multiple different ranges");
            return options;
        }

        public static void printUsage(BulkLoader.CmdLineOptions options) {
            String usage = String.format("%s [options] <keyspace> <column_family> force", StandaloneVerifier.TOOL_NAME);
            StringBuilder header = new StringBuilder();
            header.append("--\n");
            header.append("Verify the sstable for the provided table.");
            header.append("\n--\n");
            header.append("NOTE: There are significant risks associated with using this tool; it likely doesn't do what you expect and there are known edge cases. You must provide a -f or --force argument in order to allow usage of the tool -> see CASSANDRA-9947 and CASSANDRA-17017 for known risks.\n");
            header.append("https://issues.apache.org/jira/browse/CASSANDRA-9947\n");
            header.append("https://issues.apache.org/jira/browse/CASSANDRA-17017");
            header.append("\n--\n");
            header.append("Options are:");
            new HelpFormatter().printHelp(usage, header.toString(), (org.apache.commons.cli.Options)options, "");
        }
    }
}

