/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.repair.messages;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.io.IVersionedSerializer;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.repair.RepairJobDesc;
import org.apache.cassandra.repair.SyncNodePair;
import org.apache.cassandra.repair.messages.RepairMessage;
import org.apache.cassandra.streaming.SessionSummary;

public class SyncResponse
extends RepairMessage {
    public final SyncNodePair nodes;
    public final boolean success;
    public final List<SessionSummary> summaries;
    public static final IVersionedSerializer<SyncResponse> serializer = new IVersionedSerializer<SyncResponse>(){

        @Override
        public void serialize(SyncResponse message, DataOutputPlus out, int version) throws IOException {
            RepairJobDesc.serializer.serialize(message.desc, out, version);
            SyncNodePair.serializer.serialize(message.nodes, out, version);
            out.writeBoolean(message.success);
            out.writeInt(message.summaries.size());
            for (SessionSummary summary : message.summaries) {
                SessionSummary.serializer.serialize(summary, out, version);
            }
        }

        @Override
        public SyncResponse deserialize(DataInputPlus in, int version) throws IOException {
            RepairJobDesc desc = (RepairJobDesc)RepairJobDesc.serializer.deserialize(in, version);
            SyncNodePair nodes = (SyncNodePair)SyncNodePair.serializer.deserialize(in, version);
            boolean success = in.readBoolean();
            int numSummaries = in.readInt();
            ArrayList<SessionSummary> summaries = new ArrayList<SessionSummary>(numSummaries);
            for (int i = 0; i < numSummaries; ++i) {
                summaries.add((SessionSummary)SessionSummary.serializer.deserialize(in, version));
            }
            return new SyncResponse(desc, nodes, success, summaries);
        }

        @Override
        public long serializedSize(SyncResponse message, int version) {
            long size = RepairJobDesc.serializer.serializedSize(message.desc, version);
            size += SyncNodePair.serializer.serializedSize(message.nodes, version);
            size += (long)TypeSizes.sizeof(message.success);
            size += (long)TypeSizes.sizeof(message.summaries.size());
            for (SessionSummary summary : message.summaries) {
                size += SessionSummary.serializer.serializedSize(summary, version);
            }
            return size;
        }
    };

    public SyncResponse(RepairJobDesc desc, SyncNodePair nodes, boolean success, List<SessionSummary> summaries) {
        super(desc);
        this.nodes = nodes;
        this.success = success;
        this.summaries = summaries;
    }

    public SyncResponse(RepairJobDesc desc, InetAddressAndPort endpoint1, InetAddressAndPort endpoint2, boolean success, List<SessionSummary> summaries) {
        super(desc);
        this.summaries = summaries;
        this.nodes = new SyncNodePair(endpoint1, endpoint2);
        this.success = success;
    }

    public boolean equals(Object o) {
        if (!(o instanceof SyncResponse)) {
            return false;
        }
        SyncResponse other = (SyncResponse)o;
        return this.desc.equals(other.desc) && this.success == other.success && this.nodes.equals(other.nodes) && this.summaries.equals(other.summaries);
    }

    public int hashCode() {
        return Objects.hash(this.desc, this.success, this.nodes, this.summaries);
    }
}

