/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.util;

import io.netty.util.concurrent.FastThreadLocal;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.utils.ByteBufferUtil;

public abstract class DataOutputStreamPlus
extends OutputStream
implements DataOutputPlus {
    protected final WritableByteChannel channel;
    private static int MAX_BUFFER_SIZE = Integer.getInteger("cassandra.data_output_stream_plus_temp_buffer_size", 8192);
    private static final FastThreadLocal<byte[]> tempBuffer = new FastThreadLocal<byte[]>(){

        public byte[] initialValue() {
            return new byte[16];
        }
    };

    protected DataOutputStreamPlus() {
        this.channel = this.newDefaultChannel();
    }

    protected DataOutputStreamPlus(WritableByteChannel channel) {
        this.channel = channel;
    }

    protected static byte[] retrieveTemporaryBuffer(int minSize) {
        byte[] bytes = (byte[])tempBuffer.get();
        if (bytes.length < Math.min(minSize, MAX_BUFFER_SIZE)) {
            bytes = new byte[Math.min(MAX_BUFFER_SIZE, 2 * Integer.highestOneBit(minSize))];
            tempBuffer.set((Object)bytes);
        }
        return bytes;
    }

    protected WritableByteChannel newDefaultChannel() {
        return new WritableByteChannel(){

            @Override
            public boolean isOpen() {
                return true;
            }

            @Override
            public void close() {
            }

            @Override
            public int write(ByteBuffer src) throws IOException {
                int totalWritten;
                int toWriteThisTime;
                int toWrite = src.remaining();
                if (src.hasArray()) {
                    DataOutputStreamPlus.this.write(src.array(), src.arrayOffset() + src.position(), src.remaining());
                    src.position(src.limit());
                    return toWrite;
                }
                if (toWrite < 16) {
                    int offset = src.position();
                    for (int i = 0; i < toWrite; ++i) {
                        DataOutputStreamPlus.this.write(src.get(i + offset));
                    }
                    src.position(src.limit());
                    return toWrite;
                }
                byte[] buf = DataOutputStreamPlus.retrieveTemporaryBuffer(toWrite);
                for (totalWritten = 0; totalWritten < toWrite; totalWritten += toWriteThisTime) {
                    toWriteThisTime = Math.min(buf.length, toWrite - totalWritten);
                    ByteBufferUtil.copyBytes(src, src.position() + totalWritten, buf, 0, toWriteThisTime);
                    DataOutputStreamPlus.this.write(buf, 0, toWriteThisTime);
                }
                src.position(src.limit());
                return totalWritten;
            }
        };
    }
}

