/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io;

import java.io.IOError;
import java.nio.file.Path;
import org.apache.cassandra.io.util.File;

public abstract class FSError
extends IOError {
    final String message;
    public final String path;

    public FSError(Throwable cause, File path) {
        this(null, cause, path);
    }

    public FSError(Throwable cause, Path path) {
        this(null, cause, path);
    }

    public FSError(String message, Throwable cause, File path) {
        super(cause);
        this.message = message;
        this.path = path.toString();
    }

    public FSError(String message, Throwable cause, Path path) {
        super(cause);
        this.message = message;
        this.path = path.toString();
    }

    public static FSError findNested(Throwable top) {
        for (Throwable t = top; t != null; t = t.getCause()) {
            if (!(t instanceof FSError)) continue;
            return (FSError)t;
        }
        return null;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + (this.message != null ? ' ' + this.message : "") + (this.path != null ? " in " + this.path : "");
    }
}

