/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.gms;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.gms.EndpointState;
import org.apache.cassandra.gms.GossipDigest;
import org.apache.cassandra.gms.GossipDigestAck;
import org.apache.cassandra.gms.GossipDigestSyn;
import org.apache.cassandra.gms.GossipVerbHandler;
import org.apache.cassandra.gms.Gossiper;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.net.Verb;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GossipDigestSynVerbHandler
extends GossipVerbHandler<GossipDigestSyn> {
    public static final GossipDigestSynVerbHandler instance = new GossipDigestSynVerbHandler();
    private static final Logger logger = LoggerFactory.getLogger(GossipDigestSynVerbHandler.class);

    @Override
    public void doVerb(Message<GossipDigestSyn> message) {
        Message<GossipDigestAck> gDigestAckMessage;
        InetAddressAndPort from = message.from();
        if (logger.isTraceEnabled()) {
            logger.trace("Received a GossipDigestSynMessage from {}", (Object)from);
        }
        if (!Gossiper.instance.isEnabled() && !Gossiper.instance.isInShadowRound()) {
            if (logger.isTraceEnabled()) {
                logger.trace("Ignoring GossipDigestSynMessage because gossip is disabled");
            }
            return;
        }
        GossipDigestSyn gDigestMessage = (GossipDigestSyn)message.payload;
        if (!gDigestMessage.clusterId.equals(DatabaseDescriptor.getClusterName())) {
            logger.warn("ClusterName mismatch from {} {}!={}", new Object[]{from, gDigestMessage.clusterId, DatabaseDescriptor.getClusterName()});
            return;
        }
        if (gDigestMessage.partioner != null && !gDigestMessage.partioner.equals(DatabaseDescriptor.getPartitionerName())) {
            logger.warn("Partitioner mismatch from {} {}!={}", new Object[]{from, gDigestMessage.partioner, DatabaseDescriptor.getPartitionerName()});
            return;
        }
        List<GossipDigest> gDigestList = gDigestMessage.getGossipDigests();
        if (!Gossiper.instance.isEnabled() && Gossiper.instance.isInShadowRound()) {
            if (gDigestList.size() > 0) {
                logger.debug("Ignoring non-empty GossipDigestSynMessage because currently in gossip shadow round");
                return;
            }
            logger.debug("Received a shadow round syn from {}. Gossip is disabled but currently also in shadow round, responding with a minimal ack", (Object)from);
            MessagingService.instance().send(Message.out(Verb.GOSSIP_DIGEST_ACK, new GossipDigestAck(Collections.emptyList(), Collections.emptyMap())), from);
            return;
        }
        if (logger.isTraceEnabled()) {
            StringBuilder sb = new StringBuilder();
            for (GossipDigest gDigest : gDigestList) {
                sb.append(gDigest);
                sb.append(" ");
            }
            logger.trace("Gossip syn digests are : {}", (Object)sb);
        }
        Message<GossipDigestAck> message2 = gDigestAckMessage = gDigestList.isEmpty() ? GossipDigestSynVerbHandler.createShadowReply() : GossipDigestSynVerbHandler.createNormalReply(gDigestList);
        if (logger.isTraceEnabled()) {
            logger.trace("Sending a GossipDigestAckMessage to {}", (Object)from);
        }
        MessagingService.instance().send(gDigestAckMessage, from);
        super.doVerb(message);
    }

    private static Message<GossipDigestAck> createNormalReply(List<GossipDigest> gDigestList) {
        ArrayList<GossipDigest> deltaGossipDigestList = new ArrayList<GossipDigest>();
        HashMap<InetAddressAndPort, EndpointState> deltaEpStateMap = new HashMap<InetAddressAndPort, EndpointState>();
        Gossiper.instance.examineGossiper(gDigestList, deltaGossipDigestList, deltaEpStateMap);
        logger.trace("sending {} digests and {} deltas", (Object)deltaGossipDigestList.size(), (Object)deltaEpStateMap.size());
        return Message.out(Verb.GOSSIP_DIGEST_ACK, new GossipDigestAck(deltaGossipDigestList, deltaEpStateMap));
    }

    private static Message<GossipDigestAck> createShadowReply() {
        Map<InetAddressAndPort, EndpointState> stateMap = Gossiper.instance.examineShadowState();
        logger.trace("sending 0 digests and {} deltas", (Object)stateMap.size());
        return Message.out(Verb.GOSSIP_DIGEST_ACK, new GossipDigestAck(Collections.emptyList(), stateMap));
    }
}

