/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.transform;

import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.db.RegularAndStaticColumns;
import org.apache.cassandra.db.rows.EncodingStats;
import org.apache.cassandra.db.rows.Unfiltered;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.apache.cassandra.db.transform.BaseRows;
import org.apache.cassandra.db.transform.Transformation;

final class UnfilteredRows
extends BaseRows<Unfiltered, UnfilteredRowIterator>
implements UnfilteredRowIterator {
    private RegularAndStaticColumns regularAndStaticColumns;
    private DeletionTime partitionLevelDeletion;

    public UnfilteredRows(UnfilteredRowIterator input) {
        this(input, input.columns());
    }

    public UnfilteredRows(UnfilteredRowIterator input, RegularAndStaticColumns columns) {
        super(input);
        this.regularAndStaticColumns = columns;
        this.partitionLevelDeletion = input.partitionLevelDeletion();
    }

    @Override
    void add(Transformation add) {
        super.add(add);
        this.regularAndStaticColumns = add.applyToPartitionColumns(this.regularAndStaticColumns);
        this.partitionLevelDeletion = add.applyToDeletion(this.partitionLevelDeletion);
    }

    @Override
    public RegularAndStaticColumns columns() {
        return this.regularAndStaticColumns;
    }

    @Override
    public DeletionTime partitionLevelDeletion() {
        return this.partitionLevelDeletion;
    }

    @Override
    public EncodingStats stats() {
        return ((UnfilteredRowIterator)this.input).stats();
    }

    @Override
    public boolean isEmpty() {
        return this.staticRow().isEmpty() && this.partitionLevelDeletion().isLive() && !this.hasNext();
    }
}

