/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.repair;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.function.BooleanSupplier;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.repair.PendingAntiCompaction;
import org.apache.cassandra.locator.RangesAtEndpoint;
import org.apache.cassandra.repair.KeyspaceRepairManager;
import org.apache.cassandra.utils.TimeUUID;
import org.apache.cassandra.utils.concurrent.Future;

public class CassandraKeyspaceRepairManager
implements KeyspaceRepairManager {
    private final Keyspace keyspace;

    public CassandraKeyspaceRepairManager(Keyspace keyspace) {
        this.keyspace = keyspace;
    }

    @Override
    public Future<List<Void>> prepareIncrementalRepair(TimeUUID sessionID, Collection<ColumnFamilyStore> tables, RangesAtEndpoint tokenRanges, ExecutorService executor, BooleanSupplier isCancelled) {
        PendingAntiCompaction pac = new PendingAntiCompaction(sessionID, tables, tokenRanges, executor, isCancelled);
        return pac.run();
    }
}

