/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.monitoring;

import org.apache.cassandra.db.monitoring.Monitorable;
import org.apache.cassandra.db.monitoring.MonitoringState;
import org.apache.cassandra.db.monitoring.MonitoringTask;
import org.apache.cassandra.utils.MonotonicClock;

public abstract class MonitorableImpl
implements Monitorable {
    private MonitoringState state = MonitoringState.IN_PROGRESS;
    private boolean isSlow = false;
    private long approxCreationTimeNanos = -1L;
    private long timeoutNanos;
    private long slowTimeoutNanos;
    private boolean isCrossNode;

    protected MonitorableImpl() {
    }

    public void setMonitoringTime(long approxCreationTimeNanos, boolean isCrossNode, long timeoutNanos, long slowTimeoutNanos) {
        assert (approxCreationTimeNanos >= 0L);
        this.approxCreationTimeNanos = approxCreationTimeNanos;
        this.isCrossNode = isCrossNode;
        this.timeoutNanos = timeoutNanos;
        this.slowTimeoutNanos = slowTimeoutNanos;
    }

    @Override
    public long creationTimeNanos() {
        return this.approxCreationTimeNanos;
    }

    @Override
    public long timeoutNanos() {
        return this.timeoutNanos;
    }

    @Override
    public boolean isCrossNode() {
        return this.isCrossNode;
    }

    @Override
    public long slowTimeoutNanos() {
        return this.slowTimeoutNanos;
    }

    @Override
    public boolean isInProgress() {
        this.check();
        return this.state == MonitoringState.IN_PROGRESS;
    }

    @Override
    public boolean isAborted() {
        this.check();
        return this.state == MonitoringState.ABORTED;
    }

    @Override
    public boolean isCompleted() {
        this.check();
        return this.state == MonitoringState.COMPLETED;
    }

    @Override
    public boolean isSlow() {
        this.check();
        return this.isSlow;
    }

    @Override
    public boolean abort() {
        if (this.state == MonitoringState.IN_PROGRESS) {
            if (this.approxCreationTimeNanos >= 0L) {
                MonitoringTask.addFailedOperation(this, MonotonicClock.Global.approxTime.now());
            }
            this.state = MonitoringState.ABORTED;
            return true;
        }
        return this.state == MonitoringState.ABORTED;
    }

    @Override
    public boolean complete() {
        if (this.state == MonitoringState.IN_PROGRESS) {
            if (this.isSlow && this.slowTimeoutNanos > 0L && this.approxCreationTimeNanos >= 0L) {
                MonitoringTask.addSlowOperation(this, MonotonicClock.Global.approxTime.now());
            }
            this.state = MonitoringState.COMPLETED;
            return true;
        }
        return this.state == MonitoringState.COMPLETED;
    }

    private void check() {
        if (this.approxCreationTimeNanos < 0L || this.state != MonitoringState.IN_PROGRESS) {
            return;
        }
        long minElapsedNanos = MonotonicClock.Global.approxTime.now() - this.approxCreationTimeNanos - MonotonicClock.Global.approxTime.error();
        if (minElapsedNanos >= this.slowTimeoutNanos && !this.isSlow) {
            this.isSlow = true;
        }
        if (minElapsedNanos >= this.timeoutNanos) {
            this.abort();
        }
    }
}

