/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.marshal;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.cassandra.cql3.Term;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.ByteBufferAccessor;
import org.apache.cassandra.db.marshal.ValueAccessor;
import org.apache.cassandra.serializers.BytesSerializer;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.serializers.TypeSerializer;
import org.apache.cassandra.transport.ProtocolVersion;
import org.apache.cassandra.utils.ByteBufferUtil;

public abstract class AbstractCompositeType
extends AbstractType<ByteBuffer> {
    private static final String COLON = ":";
    private static final Pattern COLON_PAT = Pattern.compile(":");
    private static final String ESCAPED_COLON = "\\\\:";
    private static final Pattern ESCAPED_COLON_PAT = Pattern.compile("\\\\:");

    protected AbstractCompositeType() {
        super(AbstractType.ComparisonType.CUSTOM);
    }

    @Override
    public <VL, VR> int compareCustom(VL left, ValueAccessor<VL> accessorL, VR right, ValueAccessor<VR> accessorR) {
        boolean isStaticR;
        if (accessorL.isEmpty(left) || accessorR.isEmpty(right)) {
            return Boolean.compare(accessorR.isEmpty(right), accessorL.isEmpty(left));
        }
        boolean isStaticL = this.readIsStatic(left, accessorL);
        if (isStaticL != (isStaticR = this.readIsStatic(right, accessorR))) {
            return isStaticL ? -1 : 1;
        }
        int i = 0;
        Object previous = null;
        int offsetL = this.startingOffset(isStaticL);
        int offsetR = this.startingOffset(isStaticR);
        while (!accessorL.isEmptyFromOffset(left, offsetL) && !accessorR.isEmptyFromOffset(right, offsetR)) {
            byte bR;
            byte bL;
            AbstractType<?> comparator = this.getComparator(i, left, accessorL, right, accessorR, offsetL, offsetR);
            offsetL += this.getComparatorSize(i, left, accessorL, offsetL);
            offsetR += this.getComparatorSize(i, right, accessorR, offsetR);
            VL value1 = accessorL.sliceWithShortLength(left, offsetL);
            offsetL += accessorL.sizeWithShortLength(value1);
            VR value2 = accessorR.sliceWithShortLength(right, offsetR);
            offsetR += accessorR.sizeWithShortLength(value2);
            int cmp = comparator.compareCollectionMembers(value1, accessorL, value2, accessorR, previous);
            if (cmp != 0) {
                return cmp;
            }
            previous = value1;
            if ((bL = accessorL.getByte(left, offsetL++)) != (bR = accessorR.getByte(right, offsetR++))) {
                return bL - bR;
            }
            ++i;
        }
        if (accessorL.isEmptyFromOffset(left, offsetL)) {
            return accessorR.sizeFromOffset(right, offsetR) == 0 ? 0 : -1;
        }
        return 1;
    }

    protected abstract <V> boolean readIsStatic(V var1, ValueAccessor<V> var2);

    protected abstract int startingOffset(boolean var1);

    public ByteBuffer[] split(ByteBuffer bb) {
        ArrayList<ByteBuffer> l = new ArrayList<ByteBuffer>();
        boolean isStatic = this.readIsStatic(bb, ByteBufferAccessor.instance);
        int offset = this.startingOffset(isStatic);
        int i = 0;
        while (!ByteBufferAccessor.instance.isEmptyFromOffset(bb, offset)) {
            offset += this.getComparatorSize(i++, bb, ByteBufferAccessor.instance, offset);
            ByteBuffer value = ByteBufferAccessor.instance.sliceWithShortLength(bb, offset);
            offset += ByteBufferAccessor.instance.sizeWithShortLength(value);
            l.add(value);
            ++offset;
        }
        return l.toArray(new ByteBuffer[l.size()]);
    }

    public static String escape(String input) {
        if (input.isEmpty()) {
            return input;
        }
        String res = COLON_PAT.matcher(input).replaceAll(ESCAPED_COLON);
        char last = res.charAt(res.length() - 1);
        return last == '\\' || last == '!' ? res + '!' : res;
    }

    static String unescape(String input) {
        if (input.isEmpty()) {
            return input;
        }
        String res = ESCAPED_COLON_PAT.matcher(input).replaceAll(COLON);
        char last = res.charAt(res.length() - 1);
        return last == '!' ? res.substring(0, res.length() - 1) : res;
    }

    static List<String> split(String input) {
        if (input.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> res = new ArrayList<String>();
        int prev = 0;
        for (int i = 0; i < input.length(); ++i) {
            if (input.charAt(i) != ':' || i > 0 && input.charAt(i - 1) == '\\') continue;
            res.add(input.substring(prev, i));
            prev = i + 1;
        }
        res.add(input.substring(prev, input.length()));
        return res;
    }

    @Override
    public <V> String getString(V input, ValueAccessor<V> accessor) {
        int offset;
        StringBuilder sb = new StringBuilder();
        boolean isStatic = this.readIsStatic(input, accessor);
        int startOffset = offset = this.startingOffset(isStatic);
        int i = 0;
        while (!accessor.isEmptyFromOffset(input, offset)) {
            if (offset != startOffset) {
                sb.append(COLON);
            }
            AbstractType<?> comparator = this.getAndAppendComparator(i, input, accessor, sb, offset);
            offset += this.getComparatorSize(i, input, accessor, offset);
            V value = accessor.sliceWithShortLength(input, offset);
            offset += accessor.sizeWithShortLength(value);
            sb.append(AbstractCompositeType.escape(comparator.getString(value, accessor)));
            byte b = accessor.getByte(input, offset++);
            if (b != 0) {
                sb.append(b < 0 ? ":_" : ":!");
                break;
            }
            ++i;
        }
        return sb.toString();
    }

    @Override
    public ByteBuffer fromString(String source) {
        List<String> parts = AbstractCompositeType.split(source);
        ArrayList<ByteBuffer> components = new ArrayList<ByteBuffer>(parts.size());
        ArrayList<ParsedComparator> comparators = new ArrayList<ParsedComparator>(parts.size());
        int totalLength = 0;
        int i = 0;
        boolean lastByteIsOne = false;
        boolean lastByteIsMinusOne = false;
        for (String part : parts) {
            if (part.equals("!")) {
                lastByteIsOne = true;
                break;
            }
            if (part.equals("_")) {
                lastByteIsMinusOne = true;
                break;
            }
            ParsedComparator p = this.parseComparator(i, part);
            AbstractType<?> type = p.getAbstractType();
            part = p.getRemainingPart();
            ByteBuffer component = type.fromString(AbstractCompositeType.unescape(part));
            totalLength += p.getComparatorSerializedSize() + 2 + component.remaining() + 1;
            components.add(component);
            comparators.add(p);
            ++i;
        }
        ByteBuffer bb = ByteBuffer.allocate(totalLength);
        i = 0;
        for (ByteBuffer component : components) {
            ((ParsedComparator)comparators.get(i)).serializeComparator(bb);
            ByteBufferUtil.writeShortLength(bb, component.remaining());
            bb.put(component.duplicate());
            bb.put((byte)0);
            ++i;
        }
        if (lastByteIsOne) {
            bb.put(bb.limit() - 1, (byte)1);
        } else if (lastByteIsMinusOne) {
            bb.put(bb.limit() - 1, (byte)-1);
        }
        bb.rewind();
        return bb;
    }

    @Override
    public Term fromJSONObject(Object parsed) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String toJSONString(ByteBuffer buffer, ProtocolVersion protocolVersion) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void validate(ByteBuffer bb) throws MarshalException {
        this.validate(bb, ByteBufferAccessor.instance);
    }

    @Override
    public <V> void validate(V input, ValueAccessor<V> accessor) {
        boolean isStatic = this.readIsStatic(input, accessor);
        int offset = this.startingOffset(isStatic);
        int i = 0;
        Object previous = null;
        while (!accessor.isEmptyFromOffset(input, offset)) {
            byte b;
            AbstractType<?> comparator = this.validateComparator(i, input, accessor, offset);
            if (accessor.sizeFromOffset(input, offset += this.getComparatorSize(i, input, accessor, offset)) < 2) {
                throw new MarshalException("Not enough bytes to read value size of component " + i);
            }
            short length = accessor.getShort(input, offset);
            if (accessor.sizeFromOffset(input, offset += 2) < length) {
                throw new MarshalException("Not enough bytes to read value of component " + i);
            }
            V value = accessor.slice(input, offset, length);
            comparator.validateCollectionMember(value, previous, accessor);
            if (accessor.isEmptyFromOffset(input, offset += length)) {
                throw new MarshalException("Not enough bytes to read the end-of-component byte of component" + i);
            }
            if ((b = accessor.getByte(input, offset++)) != 0 && !accessor.isEmptyFromOffset(input, offset)) {
                throw new MarshalException("Invalid bytes remaining after an end-of-component at component" + i);
            }
            previous = value;
            ++i;
        }
    }

    @Override
    public abstract ByteBuffer decompose(Object ... var1);

    @Override
    public TypeSerializer<ByteBuffer> getSerializer() {
        return BytesSerializer.instance;
    }

    protected abstract <V> int getComparatorSize(int var1, V var2, ValueAccessor<V> var3, int var4);

    protected abstract <V> AbstractType<?> getComparator(int var1, V var2, ValueAccessor<V> var3, int var4);

    protected abstract <VL, VR> AbstractType<?> getComparator(int var1, VL var2, ValueAccessor<VL> var3, VR var4, ValueAccessor<VR> var5, int var6, int var7);

    protected abstract <V> AbstractType<?> getAndAppendComparator(int var1, V var2, ValueAccessor<V> var3, StringBuilder var4, int var5);

    protected abstract <V> AbstractType<?> validateComparator(int var1, V var2, ValueAccessor<V> var3, int var4) throws MarshalException;

    protected abstract ParsedComparator parseComparator(int var1, String var2);

    protected static interface ParsedComparator {
        public AbstractType<?> getAbstractType();

        public String getRemainingPart();

        public int getComparatorSerializedSize();

        public void serializeComparator(ByteBuffer var1);
    }
}

