/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.PeekingIterator;
import com.google.common.util.concurrent.Striped;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.function.Supplier;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.ClockAndCount;
import org.apache.cassandra.db.Clusterable;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.IMutation;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.Mutation;
import org.apache.cassandra.db.MutationExceededMaxSizeException;
import org.apache.cassandra.db.ReadExecutionController;
import org.apache.cassandra.db.SinglePartitionReadCommand;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.db.WriteType;
import org.apache.cassandra.db.context.CounterContext;
import org.apache.cassandra.db.filter.ClusteringIndexNamesFilter;
import org.apache.cassandra.db.filter.ColumnFilter;
import org.apache.cassandra.db.marshal.ByteBufferAccessor;
import org.apache.cassandra.db.partitions.PartitionUpdate;
import org.apache.cassandra.db.rows.Cell;
import org.apache.cassandra.db.rows.ColumnData;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.db.rows.RowIterator;
import org.apache.cassandra.db.rows.UnfilteredRowIterators;
import org.apache.cassandra.exceptions.WriteTimeoutException;
import org.apache.cassandra.io.IVersionedSerializer;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.locator.AbstractReplicationStrategy;
import org.apache.cassandra.schema.TableId;
import org.apache.cassandra.service.CacheService;
import org.apache.cassandra.tracing.Tracing;
import org.apache.cassandra.utils.Clock;
import org.apache.cassandra.utils.CounterId;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.btree.BTreeSet;

public class CounterMutation
implements IMutation {
    public static final CounterMutationSerializer serializer = new CounterMutationSerializer();
    private static final Striped<Lock> LOCKS = Striped.lazyWeakLock((int)(DatabaseDescriptor.getConcurrentCounterWriters() * 1024));
    private final Mutation mutation;
    private final ConsistencyLevel consistency;
    private int serializedSize30;
    private int serializedSize3014;
    private int serializedSize40;

    public CounterMutation(Mutation mutation, ConsistencyLevel consistency) {
        this.mutation = mutation;
        this.consistency = consistency;
    }

    @Override
    public String getKeyspaceName() {
        return this.mutation.getKeyspaceName();
    }

    @Override
    public Collection<TableId> getTableIds() {
        return this.mutation.getTableIds();
    }

    @Override
    public Collection<PartitionUpdate> getPartitionUpdates() {
        return this.mutation.getPartitionUpdates();
    }

    @Override
    public Supplier<Mutation> hintOnFailure() {
        return null;
    }

    @Override
    public void validateSize(int version, int overhead) {
        long totalSize = this.serializedSize(version) + overhead;
        if (totalSize > MAX_MUTATION_SIZE) {
            throw new MutationExceededMaxSizeException(this, version, totalSize);
        }
    }

    public Mutation getMutation() {
        return this.mutation;
    }

    @Override
    public DecoratedKey key() {
        return this.mutation.key();
    }

    public ConsistencyLevel consistency() {
        return this.consistency;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Mutation applyCounterMutation() throws WriteTimeoutException {
        Mutation.PartitionUpdateCollector resultBuilder = new Mutation.PartitionUpdateCollector(this.getKeyspaceName(), this.key());
        Keyspace keyspace = Keyspace.open(this.getKeyspaceName());
        ArrayList<Lock> locks = new ArrayList<Lock>();
        Tracing.trace("Acquiring counter locks");
        try {
            this.grabCounterLocks(keyspace, locks);
            for (PartitionUpdate upd : this.getPartitionUpdates()) {
                resultBuilder.add(this.processModifications(upd));
            }
            Mutation result = resultBuilder.build();
            result.apply();
            Mutation mutation = result;
            return mutation;
        }
        finally {
            for (Lock lock : locks) {
                lock.unlock();
            }
        }
    }

    @Override
    public void apply() {
        this.applyCounterMutation();
    }

    private void grabCounterLocks(Keyspace keyspace, List<Lock> locks) throws WriteTimeoutException {
        long startTime = Clock.Global.nanoTime();
        AbstractReplicationStrategy replicationStrategy = keyspace.getReplicationStrategy();
        for (Lock lock : LOCKS.bulkGet(this.getCounterLockKeys())) {
            long timeout = this.getTimeout(TimeUnit.NANOSECONDS) - (Clock.Global.nanoTime() - startTime);
            try {
                if (!lock.tryLock(timeout, TimeUnit.NANOSECONDS)) {
                    throw new WriteTimeoutException(WriteType.COUNTER, this.consistency(), 0, this.consistency().blockFor(replicationStrategy));
                }
                locks.add(lock);
            }
            catch (InterruptedException e) {
                throw new WriteTimeoutException(WriteType.COUNTER, this.consistency(), 0, this.consistency().blockFor(replicationStrategy));
            }
        }
    }

    private Iterable<Object> getCounterLockKeys() {
        return Iterables.concat((Iterable)Iterables.transform(this.getPartitionUpdates(), (Function)new Function<PartitionUpdate, Iterable<Object>>(){

            public Iterable<Object> apply(final PartitionUpdate update) {
                return Iterables.concat((Iterable)Iterables.transform((Iterable)update, (Function)new Function<Row, Iterable<Object>>(){

                    public Iterable<Object> apply(final Row row) {
                        return Iterables.concat((Iterable[])new Iterable[]{Iterables.transform((Iterable)row, (Function)new Function<ColumnData, Object>(){

                            public Object apply(ColumnData data) {
                                return Objects.hashCode((Object[])new Object[]{update.metadata().id, CounterMutation.this.key(), row.clustering(), data.column()});
                            }
                        })});
                    }
                }));
            }
        }));
    }

    private PartitionUpdate processModifications(PartitionUpdate changes) {
        ColumnFamilyStore cfs = Keyspace.open(this.getKeyspaceName()).getColumnFamilyStore(changes.metadata().id);
        List<PartitionUpdate.CounterMark> marks = changes.collectCounterMarks();
        if (CacheService.instance.counterCache.getCapacity() != 0L) {
            Tracing.trace("Fetching {} counter values from cache", (Object)marks.size());
            this.updateWithCurrentValuesFromCache(marks, cfs);
            if (marks.isEmpty()) {
                return changes;
            }
        }
        Tracing.trace("Reading {} counter values from the CF", (Object)marks.size());
        this.updateWithCurrentValuesFromCFS(marks, cfs);
        for (PartitionUpdate.CounterMark mark : marks) {
            this.updateWithCurrentValue(mark, ClockAndCount.BLANK, cfs);
        }
        return changes;
    }

    private void updateWithCurrentValue(PartitionUpdate.CounterMark mark, ClockAndCount currentValue, ColumnFamilyStore cfs) {
        long clock = Math.max(FBUtilities.timestampMicros(), currentValue.clock + 1L);
        long count = currentValue.count + CounterContext.instance().total(mark.value(), ByteBufferAccessor.instance);
        mark.setValue(CounterContext.instance().createGlobal(CounterId.getLocalId(), clock, count));
        cfs.putCachedCounter(this.key().getKey(), mark.clustering(), mark.column(), mark.path(), ClockAndCount.create(clock, count));
    }

    private void updateWithCurrentValuesFromCache(List<PartitionUpdate.CounterMark> marks, ColumnFamilyStore cfs) {
        Iterator<PartitionUpdate.CounterMark> iter = marks.iterator();
        while (iter.hasNext()) {
            PartitionUpdate.CounterMark mark = iter.next();
            ClockAndCount cached = cfs.getCachedCounter(this.key().getKey(), mark.clustering(), mark.column(), mark.path());
            if (cached == null) continue;
            this.updateWithCurrentValue(mark, cached, cfs);
            iter.remove();
        }
    }

    private void updateWithCurrentValuesFromCFS(List<PartitionUpdate.CounterMark> marks, ColumnFamilyStore cfs) {
        ColumnFilter.Builder builder = ColumnFilter.selectionBuilder();
        BTreeSet.Builder<Clusterable> names = BTreeSet.builder(cfs.metadata().comparator);
        for (PartitionUpdate.CounterMark mark : marks) {
            if (mark.clustering() != Clustering.STATIC_CLUSTERING) {
                names.add(mark.clustering());
            }
            if (mark.path() == null) {
                builder.add(mark.column());
                continue;
            }
            builder.select(mark.column(), mark.path());
        }
        int nowInSec = FBUtilities.nowInSeconds();
        ClusteringIndexNamesFilter filter = new ClusteringIndexNamesFilter(names.build(), false);
        SinglePartitionReadCommand cmd = SinglePartitionReadCommand.create(cfs.metadata(), nowInSec, this.key(), builder.build(), filter);
        PeekingIterator markIter = Iterators.peekingIterator(marks.iterator());
        try (ReadExecutionController controller = cmd.executionController();){
            RowIterator partition = UnfilteredRowIterators.filter(cmd.queryMemtableAndDisk(cfs, controller), nowInSec);
            Throwable throwable = null;
            try {
                this.updateForRow((PeekingIterator<PartitionUpdate.CounterMark>)markIter, partition.staticRow(), cfs);
            }
            catch (Throwable throwable2) {
                try {
                    throwable = throwable2;
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    if (partition != null) {
                        if (throwable != null) {
                            try {
                                partition.close();
                            }
                            catch (Throwable throwable4) {
                                throwable.addSuppressed(throwable4);
                            }
                        } else {
                            partition.close();
                        }
                    }
                    throw throwable3;
                }
            }
        }
    }

    private int compare(Clustering<?> c1, Clustering<?> c2, ColumnFamilyStore cfs) {
        if (c1 == Clustering.STATIC_CLUSTERING) {
            return c2 == Clustering.STATIC_CLUSTERING ? 0 : -1;
        }
        if (c2 == Clustering.STATIC_CLUSTERING) {
            return 1;
        }
        return cfs.getComparator().compare(c1, c2);
    }

    private void updateForRow(PeekingIterator<PartitionUpdate.CounterMark> markIter, Row row, ColumnFamilyStore cfs) {
        int cmp = 0;
        while (markIter.hasNext() && (cmp = this.compare(((PartitionUpdate.CounterMark)markIter.peek()).clustering(), (Clustering<?>)row.clustering(), cfs)) < 0) {
            markIter.next();
        }
        if (!markIter.hasNext()) {
            return;
        }
        while (cmp == 0) {
            Cell<?> cell;
            PartitionUpdate.CounterMark mark = (PartitionUpdate.CounterMark)markIter.next();
            Cell<?> cell2 = cell = mark.path() == null ? row.getCell(mark.column()) : row.getCell(mark.column(), mark.path());
            if (cell != null) {
                this.updateWithCurrentValue(mark, CounterContext.instance().getLocalClockAndCount(cell.buffer()), cfs);
                markIter.remove();
            }
            if (!markIter.hasNext()) {
                return;
            }
            cmp = this.compare(((PartitionUpdate.CounterMark)markIter.peek()).clustering(), (Clustering<?>)row.clustering(), cfs);
        }
    }

    @Override
    public long getTimeout(TimeUnit unit) {
        return DatabaseDescriptor.getCounterWriteRpcTimeout(unit);
    }

    public int serializedSize(int version) {
        switch (version) {
            case 10: {
                if (this.serializedSize30 == 0) {
                    this.serializedSize30 = (int)serializer.serializedSize(this, 10);
                }
                return this.serializedSize30;
            }
            case 11: {
                if (this.serializedSize3014 == 0) {
                    this.serializedSize3014 = (int)serializer.serializedSize(this, 11);
                }
                return this.serializedSize3014;
            }
            case 12: {
                if (this.serializedSize40 == 0) {
                    this.serializedSize40 = (int)serializer.serializedSize(this, 12);
                }
                return this.serializedSize40;
            }
        }
        throw new IllegalStateException("Unknown serialization version: " + version);
    }

    public String toString() {
        return this.toString(false);
    }

    @Override
    public String toString(boolean shallow) {
        return String.format("CounterMutation(%s, %s)", new Object[]{this.mutation.toString(shallow), this.consistency});
    }

    public static class CounterMutationSerializer
    implements IVersionedSerializer<CounterMutation> {
        @Override
        public void serialize(CounterMutation cm, DataOutputPlus out, int version) throws IOException {
            Mutation.serializer.serialize(cm.mutation, out, version);
            out.writeUTF(cm.consistency.name());
        }

        @Override
        public CounterMutation deserialize(DataInputPlus in, int version) throws IOException {
            Mutation m = Mutation.serializer.deserialize(in, version);
            ConsistencyLevel consistency = Enum.valueOf(ConsistencyLevel.class, in.readUTF());
            return new CounterMutation(m, consistency);
        }

        @Override
        public long serializedSize(CounterMutation cm, int version) {
            return cm.mutation.serializedSize(version) + TypeSizes.sizeof(cm.consistency.name());
        }
    }
}

