/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import com.google.common.base.Preconditions;
import org.apache.cassandra.db.WriteContext;
import org.apache.cassandra.db.commitlog.CommitLogPosition;
import org.apache.cassandra.utils.concurrent.OpOrder;

public class CassandraWriteContext
implements WriteContext {
    private final OpOrder.Group opGroup;
    private final CommitLogPosition position;

    public CassandraWriteContext(OpOrder.Group opGroup, CommitLogPosition position) {
        Preconditions.checkArgument((opGroup != null ? 1 : 0) != 0);
        this.opGroup = opGroup;
        this.position = position;
    }

    public static CassandraWriteContext fromContext(WriteContext context) {
        Preconditions.checkArgument((boolean)(context instanceof CassandraWriteContext));
        return (CassandraWriteContext)context;
    }

    public OpOrder.Group getGroup() {
        return this.opGroup;
    }

    public CommitLogPosition getPosition() {
        return this.position;
    }

    @Override
    public void close() {
        this.opGroup.close();
    }
}

