/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.selection;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.cassandra.cql3.ResultSet;
import org.apache.cassandra.cql3.selection.Selection;
import org.apache.cassandra.cql3.selection.Selector;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.aggregation.GroupMaker;
import org.apache.cassandra.db.rows.Cell;

public final class ResultSetBuilder {
    private final ResultSet resultSet;
    private final Selection.Selectors selectors;
    private final GroupMaker groupMaker;
    private Selector.InputRow inputRow;
    private long size = 0L;
    private boolean sizeWarningEmitted = false;

    public ResultSetBuilder(ResultSet.ResultMetadata metadata, Selection.Selectors selectors) {
        this(metadata, selectors, null);
    }

    public ResultSetBuilder(ResultSet.ResultMetadata metadata, Selection.Selectors selectors, GroupMaker groupMaker) {
        this.resultSet = new ResultSet(metadata.copy(), new ArrayList<List<ByteBuffer>>());
        this.selectors = selectors;
        this.groupMaker = groupMaker;
    }

    private void addSize(List<ByteBuffer> row) {
        int isize = row.size();
        for (int i = 0; i < isize; ++i) {
            ByteBuffer value = row.get(i);
            this.size += value != null ? (long)value.remaining() : 0L;
        }
    }

    public boolean shouldWarn(long thresholdBytes) {
        if (thresholdBytes != -1L && !this.sizeWarningEmitted && this.size > thresholdBytes) {
            this.sizeWarningEmitted = true;
            return true;
        }
        return false;
    }

    public boolean shouldReject(long thresholdBytes) {
        return thresholdBytes != -1L && this.size > thresholdBytes;
    }

    public long getSize() {
        return this.size;
    }

    public void add(ByteBuffer v) {
        this.inputRow.add(v);
    }

    public void add(Cell<?> c, int nowInSec) {
        this.inputRow.add(c, nowInSec);
    }

    public void newRow(DecoratedKey partitionKey, Clustering<?> clustering) {
        boolean isNewAggregate;
        boolean bl = isNewAggregate = this.groupMaker == null || this.groupMaker.isNewGroup(partitionKey, clustering);
        if (this.inputRow != null) {
            this.selectors.addInputRow(this.inputRow);
            if (isNewAggregate) {
                this.resultSet.addRow(this.getOutputRow());
                this.inputRow.reset(!this.selectors.hasProcessing());
                this.selectors.reset();
            } else {
                this.inputRow.reset(!this.selectors.hasProcessing());
            }
        } else {
            this.inputRow = new Selector.InputRow(this.selectors.numberOfFetchedColumns(), this.selectors.collectTimestamps(), this.selectors.collectTTLs());
        }
    }

    public ResultSet build() {
        if (this.inputRow != null) {
            this.selectors.addInputRow(this.inputRow);
            this.resultSet.addRow(this.getOutputRow());
            this.inputRow.reset(!this.selectors.hasProcessing());
            this.selectors.reset();
        }
        if (this.resultSet.isEmpty() && this.groupMaker != null && this.groupMaker.returnAtLeastOneRow()) {
            this.resultSet.addRow(this.getOutputRow());
        }
        return this.resultSet;
    }

    private List<ByteBuffer> getOutputRow() {
        List<ByteBuffer> row = this.selectors.getOutputRow();
        this.addSize(row);
        return row;
    }
}

